package com.ximai.common.core.domain.entity;

import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import com.ximai.common.utils.SecurityUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 菜单权限表 sys_menu
 *
 */
@Data
public class SysMenu extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 菜单ID */
    private Long menuId;

    /** 菜单名称 */
    private String menuName;

    /** 父菜单名称 */
    private String parentName;

    /** 父菜单ID */
    private Long parentId;

    /** 显示顺序 */
    private Integer orderNum;

    /** 路由地址 */
    private String path;

    /** 组件路径 */
    private String component;

    /** 路由参数 */
    private String query;

    /** 是否为外链（0是 1否） */
    private String isFrame;

    /** 是否缓存（0缓存 1不缓存） */
    private String isCache;

    /** 类型（M目录 C菜单 F按钮） */
    private String menuType;

    /** 显示状态（0显示 1隐藏） */
    private String visible;

    /** 菜单状态（0显示 1隐藏） */
    private String status;

    /** 权限字符串 */
    private String perms;

    /** 菜单图标 */
    private String icon;

    /** 子菜单 */
    private List<SysMenu> children = new ArrayList<SysMenu>();

    /** 菜单英文名称 */
    @ApiModelProperty("菜单英文名称")
    private String menuNameEn;


    /** 菜单泰文名称 */
    @ApiModelProperty("菜单泰文名称")
    private String menuNameTh;

    public String localMenuName(){
        String locale = SecurityUtils.getLoginUser().getUser().getLocale();
        if(StringUtils.isNotEmpty(locale)){
            if(locale.indexOf("th")!=-1){
                if(StringUtils.isNoneBlank(this.getMenuNameTh())){
                    return this.getMenuNameTh();
                }
            }else if(locale.indexOf("en")!=-1){
                if(StringUtils.isNoneBlank(this.getMenuNameEn())){
                    return this.getMenuNameEn();
                }
            }
        }
        return this.getMenuName();
    }


}
