package com.ximai.mes.report.service.impl;

import com.ximai.common.utils.MessageUtils;
import com.ximai.common.utils.data.ExceptionUtil;
import com.ximai.mes.report.mapper.DailyProductionReportMapper;
import com.ximai.mes.report.request.DailyProductionReportRequest;
import com.ximai.mes.report.service.DailyProductionReportService;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

@Service
public class DailyProductionReportServiceImp implements DailyProductionReportService {

    @Autowired
    DailyProductionReportMapper dailyProductionReportMapper;


    @Override
    public List getListByProcess(DailyProductionReportRequest dailyProductionReportRequest) {
        ExceptionUtil.checkTrueThrowException(dailyProductionReportRequest.getStartDate() == null
                && dailyProductionReportRequest.getEndDate() == null,
                "请传入开始和结束时间");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        List<Map> processDataList = dailyProductionReportMapper.getListByProcess(dailyProductionReportRequest);
        String startDate = simpleDateFormat.format(dailyProductionReportRequest.getStartDate());
        String endDate = simpleDateFormat.format(dailyProductionReportRequest.getEndDate());
        List<String> dateList = getAscDateList(startDate, endDate);
        List<Map> returnList = groupList(processDataList,"工序名称","工序编码","工序",dateList);
        return returnList;
    }


    @Override
    public List getListByWorkshop(DailyProductionReportRequest dailyProductionReportRequest) {
        ExceptionUtil.checkTrueThrowException(dailyProductionReportRequest.getStartDate() == null
                        && dailyProductionReportRequest.getEndDate() == null,
                "请传入开始和结束时间");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        List<Map> processDataList = dailyProductionReportMapper.getListByWorkshop(dailyProductionReportRequest);
        String startDate = simpleDateFormat.format(dailyProductionReportRequest.getStartDate());
        String endDate = simpleDateFormat.format(dailyProductionReportRequest.getEndDate());
        List<String> dateList = getAscDateList(startDate, endDate);
        List<Map> returnList = groupList(processDataList,"车间名称","车间编码","车间",dateList);
        return returnList;
    }

    @Override
    public List getListByWorkstation(DailyProductionReportRequest dailyProductionReportRequest) {
        ExceptionUtil.checkTrueThrowException(dailyProductionReportRequest.getStartDate() == null
                        && dailyProductionReportRequest.getEndDate() == null,
                "请传入开始和结束时间");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        List<Map> processDataList = dailyProductionReportMapper.getListByWorkstation(dailyProductionReportRequest);
        String startDate = simpleDateFormat.format(dailyProductionReportRequest.getStartDate());
        String endDate = simpleDateFormat.format(dailyProductionReportRequest.getEndDate());
        List<String> dateList = getAscDateList(startDate, endDate);
        List<Map> returnList = groupList(processDataList,"工作中心名称","工作中心编码","工作中心",dateList);
        return returnList;
    }

    @Override
    public List getListByWorkunit(DailyProductionReportRequest dailyProductionReportRequest) {
        ExceptionUtil.checkTrueThrowException(dailyProductionReportRequest.getStartDate() == null
                        && dailyProductionReportRequest.getEndDate() == null,
                "请传入开始和结束时间");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        List<Map> processDataList = dailyProductionReportMapper.getListByWorkunit(dailyProductionReportRequest);
        String startDate = simpleDateFormat.format(dailyProductionReportRequest.getStartDate());
        String endDate = simpleDateFormat.format(dailyProductionReportRequest.getEndDate());
        List<String> dateList = getAscDateList(startDate, endDate);
        List<Map> returnList = groupList(processDataList,"工作单元名称","工作单元编码","工作单元",dateList);
        return returnList;
    }

    @Override
    public List getListByUser(DailyProductionReportRequest dailyProductionReportRequest) {
        ExceptionUtil.checkTrueThrowException(dailyProductionReportRequest.getStartDate() == null
                        && dailyProductionReportRequest.getEndDate() == null,
                "请传入开始和结束时间");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        List<Map> processDataList = dailyProductionReportMapper.getListByUser(dailyProductionReportRequest);
        String startDate = simpleDateFormat.format(dailyProductionReportRequest.getStartDate());
        String endDate = simpleDateFormat.format(dailyProductionReportRequest.getEndDate());
        List<String> dateList = getAscDateList(startDate, endDate);
        List<Map> returnList = groupList(processDataList,"报工人员名称","报工人员编码","报工人员",dateList);
        return returnList;
    }

    @Override
    public List getDatas(DailyProductionReportRequest dailyProductionReportRequest) {
        ExceptionUtil.checkTrueThrowException(dailyProductionReportRequest.getStartDate() == null
                        && dailyProductionReportRequest.getEndDate() == null,
                "请传入开始和结束时间");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String startDate = simpleDateFormat.format(dailyProductionReportRequest.getStartDate());
        String endDate = simpleDateFormat.format(dailyProductionReportRequest.getEndDate());
        List<String> dateList = getAscDateList(startDate, endDate);
        return dateList;
    }

    public static List<String> getAscDateList(String start, String end) {

        LocalDate startDate = LocalDate.parse(start);
        LocalDate endDate = LocalDate.parse(end);
        List<String> result = new ArrayList<>();
        if (endDate.compareTo(startDate) < 0) {
            return result;
        }
        while (true) {
            result.add(startDate.toString());
            if (startDate.compareTo(endDate) >= 0) {
                break;
            }
            startDate = startDate.plusDays(1);
        }
        return result;
    }

    public List groupList(List<Map> processDataList,String name,String code,String key,List<String> dateList  ){
        Map<String,List<Map>> processDataMap = processDataList.stream().collect(Collectors.groupingBy(map -> (String)map.get(code)));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        /**
         * ［｛工序名称：abc，工序编码：cbd,工序总结：1，日期a：｛合格数｝｝］
         */
        List<Map> returnList = new ArrayList<>();
        for (String processCode : processDataMap.keySet()){
            HashMap processHashMap = new HashMap();
            returnList.add(processHashMap);
            processHashMap.put(code,processCode);
            processHashMap.put(name,processDataMap.get(processCode).get(0).get(name));
            processHashMap.put(key + "统计合格数量", new Double(0));
            processHashMap.put(key + "统计不合格数量",new Double(0));
            processHashMap.put(key + "统计报工数量",new Double(0));
            Map<String,List<Map>> dateDataMap = processDataMap.get(processCode).stream().collect(Collectors.groupingBy(map -> (String)map.get("报工日期")));
            for (String date : dateList){
                HashMap dateHashMap = new HashMap();
                processHashMap.put(date,dateHashMap);
                if(dateDataMap.get(date) != null){
                    for (Map data : dateDataMap.get(date)){
                        //PS这里其实做多只有一条Map data
                        dateHashMap.put("合格数量",data.get("合格数量"));
                        dateHashMap.put("不合格数量",data.get("不合格数量"));
                        dateHashMap.put("报工数量",data.get("报工数量"));
                        dateHashMap.put("合格率",(new BigDecimal((Double) data.get("合格数量")).multiply(new BigDecimal(100))).divide( new BigDecimal((Double) data.get("报工数量")),2, RoundingMode.HALF_UP));
                        processHashMap.put(key + "统计合格数量", ((Double)processHashMap.get(key + "统计合格数量")) + ((Double)data.get("合格数量")));
                        processHashMap.put(key + "统计不合格数量",((Double)processHashMap.get(key + "统计不合格数量")) + ((Double)data.get("不合格数量")));
                        processHashMap.put(key + "统计报工数量",((Double)processHashMap.get(key + "统计报工数量")) + ((Double)data.get("报工数量")));
                    }
                }
            }
            processHashMap.put(key + "统计合格率",(new BigDecimal((Double) processHashMap.get(key + "统计合格数量")).multiply(new BigDecimal(100))).divide(new BigDecimal((Double)processHashMap.get(key + "统计报工数量")),2, RoundingMode.HALF_UP));
        }


        //用于统计最后一行的日期综合统计性数据
        Map<String,List<Map>> dateDataMap = processDataList.stream().collect(Collectors.groupingBy(map -> (String)map.get("报工日期")));
        HashMap dateHashMap = new HashMap();
        returnList.add(dateHashMap);
        for (String date : dateList){
            HashMap dateStatisticsHashMap = new HashMap();
            dateHashMap.put(date,dateStatisticsHashMap);
            dateStatisticsHashMap.put("日期统计合格数量", new Double(0));
            dateStatisticsHashMap.put("日期统计不合格数量",new Double(0));
            dateStatisticsHashMap.put("日期统计报工数量",new Double(0));
            if(dateDataMap.get(date) != null){
                for (Map data : dateDataMap.get(date)){
                    dateStatisticsHashMap.put("日期统计合格数量", ((Double)dateStatisticsHashMap.get("日期统计合格数量")) + ((Double)data.get("合格数量")));
                    dateStatisticsHashMap.put("日期统计不合格数量",((Double)dateStatisticsHashMap.get("日期统计不合格数量")) + ((Double)data.get("不合格数量")));
                    dateStatisticsHashMap.put("日期统计报工数量",((Double)dateStatisticsHashMap.get("日期统计报工数量")) + ((Double)data.get("报工数量")));
                }
            }

            if(((Double)dateStatisticsHashMap.get("日期统计报工数量")) > 0){
                dateStatisticsHashMap.put("日期统计合格率",


                        new BigDecimal((Double)dateStatisticsHashMap.get("日期统计合格数量")).multiply(new BigDecimal(100)).divide(new BigDecimal((Double)dateStatisticsHashMap.get("日期统计报工数量")),2, RoundingMode.HALF_UP));
            }else{
                dateStatisticsHashMap.put("日期统计合格率",BigDecimal.ZERO);
            }
        }


        return returnList;
    }
}
