package com.ximai.mes.report.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.report.request.DailyProductionReportRequest;
import com.ximai.mes.report.request.WeeklyProductionReportRequest;
import com.ximai.mes.report.service.MonthlyProductionReportService;
import com.ximai.mes.report.service.WeeklyProductionReportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Api("周产能对比统计")
@RestController
@RequestMapping("/weeklyProductionReport")
public class WeeklyProductionReportController {
    @Autowired
    WeeklyProductionReportService weeklyProductionReportService;


    @ApiOperation("日产能对比统计:获取周表头")
    @PreAuthorize("@ss.hasPermi('mes:pro:dailyProductionReport:get')")
    @Log(title = "日产能对比统计:获取周表头", businessType = BusinessType.QUERY)
    @GetMapping("/getDatas")
    public AjaxResult<List> getDatas(WeeklyProductionReportRequest weeklyProductionReportRequest) {
        List data = weeklyProductionReportService.getDatas(weeklyProductionReportRequest);
        return AjaxResult.success(data);
    }




    @ApiOperation("周产能对比统计:统计方式工序")
    @PreAuthorize("@ss.hasPermi('mes:pro:dailyProductionReport:get')")
    @Log(title = "周产能对比统计:统计方式工序", businessType = BusinessType.QUERY)
    @GetMapping("/getListByProcess")
    public AjaxResult<List> getListByProcess(WeeklyProductionReportRequest weeklyProductionReportRequest) {
        List data = weeklyProductionReportService.getListByProcess(weeklyProductionReportRequest);
        return AjaxResult.success(data);
    }



    @ApiOperation("周产能对比统计:统计方式车间")
    @PreAuthorize("@ss.hasPermi('mes:pro:dailyProductionReport:get')")
    @Log(title = "周产能对比统计:统计方式车间", businessType = BusinessType.QUERY)
    @GetMapping("/getListByWorkshop")
    public AjaxResult<List> getListByWorkshop(WeeklyProductionReportRequest weeklyProductionReportRequest) {
        List data = weeklyProductionReportService.getListByWorkshop(weeklyProductionReportRequest);
        return AjaxResult.success(data);
    }


    @ApiOperation("周产能对比统计:统计方式工作中心")
    @PreAuthorize("@ss.hasPermi('mes:pro:dailyProductionReport:get')")
    @Log(title = "周产能对比统计:统计方式工作中心", businessType = BusinessType.QUERY)
    @GetMapping("/getListByWorkstation")
    public AjaxResult<List> getListByWorkstation(WeeklyProductionReportRequest weeklyProductionReportRequest) {
        List data = weeklyProductionReportService.getListByWorkstation(weeklyProductionReportRequest);
        return AjaxResult.success(data);
    }
    @ApiOperation("周产能对比统计:统计方式工作单元")
    @PreAuthorize("@ss.hasPermi('mes:pro:dailyProductionReport:get')")
    @Log(title = "周产能对比统计:统计方式工作单元", businessType = BusinessType.QUERY)
    @GetMapping("/getListByWorkunit")
    public AjaxResult<List> getListByWorkunit(WeeklyProductionReportRequest weeklyProductionReportRequest) {
        List data = weeklyProductionReportService.getListByWorkunit(weeklyProductionReportRequest);
        return AjaxResult.success(data);
    }

    @ApiOperation("周产能对比统计:统计方式报工人员")
    @PreAuthorize("@ss.hasPermi('mes:pro:dailyProductionReport:get')")
    @Log(title = "周产能对比统计:统计方式报工人员", businessType = BusinessType.QUERY)
    @GetMapping("/getListByUser")
    public AjaxResult<List> getListByUser(WeeklyProductionReportRequest weeklyProductionReportRequest) {
        List data = weeklyProductionReportService.getListByUser(weeklyProductionReportRequest);
        return AjaxResult.success(data);
    }

}
