package com.ximai.mes.qc.service;

import java.util.List;
import com.ximai.mes.qc.domain.QcAbnormalInformation;

/**
 * 异常信息Service接口
 *
 * @author generator
 * @date 2024-02-19
 */
public interface IQcAbnormalInformationService
{
    /**
     * 查询异常信息
     *
     * @param abnormalId 异常信息主键
     * @return 异常信息
     */
    public QcAbnormalInformation selectQcAbnormalInformationByAbnormalId(Long abnormalId);

    /**
     * 查询异常信息列表
     *
     * @param qcAbnormalInformation 异常信息
     * @return 异常信息集合
     */
    public List<QcAbnormalInformation> selectQcAbnormalInformationList(QcAbnormalInformation qcAbnormalInformation);

    /**
     * 新增异常信息
     *
     * @param qcAbnormalInformation 异常信息
     * @return 结果
     */
    public int insertQcAbnormalInformation(QcAbnormalInformation qcAbnormalInformation);

    /**
     * 修改异常信息
     *
     * @param qcAbnormalInformation 异常信息
     * @return 结果
     */
    public int updateQcAbnormalInformation(QcAbnormalInformation qcAbnormalInformation);

    /**
     * 批量删除异常信息
     *
     * @param abnormalIds 需要删除的异常信息主键集合
     * @return 结果
     */
    public int deleteQcAbnormalInformationByAbnormalIds(Long[] abnormalIds);

    /**
     * 删除异常信息信息
     *
     * @param abnormalId 异常信息主键
     * @return 结果
     */
    public int deleteQcAbnormalInformationByAbnormalId(Long abnormalId);
}
