package com.ximai.mes.pro.service.impl.task;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Objects;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.ProFeedback;
import com.ximai.mes.pro.domain.task.ProTask;
import com.ximai.mes.pro.domain.vo.ProTaskWorkorderReportFormListVo;
import com.ximai.mes.pro.domain.vo.ProWorkOrderProcessVo;
import com.ximai.mes.pro.mapper.ProFeedbackMapper;
import com.ximai.mes.pro.mapper.proWorkOrder.ProWorkOrderProcessMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.task.ProTaskWorkorderMapper;
import com.ximai.mes.pro.domain.task.ProTaskWorkorder;
import com.ximai.mes.pro.service.task.IProTaskWorkorderService;

/**
 * 任务合并工单Service业务层处理
 *
 * @author zht
 * @date 2024-01-23
 */
@Service
public class ProTaskWorkorderServiceImpl implements IProTaskWorkorderService
{
    @Autowired
    private ProTaskWorkorderMapper proTaskWorkorderMapper;

    @Autowired
    private ProWorkOrderProcessMapper proWorkOrderProcessMapper;

    @Autowired
    private ProFeedbackMapper proFeedbackMapper;

    /**
     * 查询任务合并工单
     *
     * @param taskWorkorderId 任务合并工单主键
     * @return 任务合并工单
     */
    @Override
    public ProTaskWorkorder selectProTaskWorkorderByTaskWorkorderId(Long taskWorkorderId)
    {
        return proTaskWorkorderMapper.selectProTaskWorkorderByTaskWorkorderId(taskWorkorderId);
    }

    /**
     * 查询任务合并工单列表
     *
     * @param proTaskWorkorder 任务合并工单
     * @return 任务合并工单
     */
    @Override
    public List<ProTaskWorkorder> selectProTaskWorkorderList(ProTaskWorkorder proTaskWorkorder)
    {
        return proTaskWorkorderMapper.selectProTaskWorkorderList(proTaskWorkorder);
    }

    @Override
    public List<ProTaskWorkorder> selectProTaskWorkorder(QueryWrapper<ProTaskWorkorder> query) {
        return proTaskWorkorderMapper.selectProTaskWorkorder(query);
    }

    /**
     * 新增任务合并工单
     *
     * @param proTaskWorkorder 任务合并工单
     * @return 结果
     */
    @Override
    public int insertProTaskWorkorder(ProTaskWorkorder proTaskWorkorder)
    {
        return proTaskWorkorderMapper.insertProTaskWorkorder(proTaskWorkorder);
    }

    /**
     * 修改任务合并工单
     *
     * @param proTaskWorkorder 任务合并工单
     * @return 结果
     */
    @Override
    public int updateProTaskWorkorder(ProTaskWorkorder proTaskWorkorder)
    {
        return proTaskWorkorderMapper.updateProTaskWorkorder(proTaskWorkorder);
    }

    /**
     * 批量删除任务合并工单
     *
     * @param taskWorkorderIds 需要删除的任务合并工单主键
     * @return 结果
     */
    @Override
    public int deleteProTaskWorkorderByTaskWorkorderIds(Long[] taskWorkorderIds)
    {
        return proTaskWorkorderMapper.deleteProTaskWorkorderByTaskWorkorderIds(taskWorkorderIds);
    }

    /**
     * 删除任务合并工单信息
     *
     * @param taskWorkorderId 任务合并工单主键
     * @return 结果
     */
    @Override
    public int deleteProTaskWorkorderByTaskWorkorderId(Long taskWorkorderId)
    {
        return proTaskWorkorderMapper.deleteProTaskWorkorderByTaskWorkorderId(taskWorkorderId);
    }

    @Override
    public List<ProTaskWorkorderReportFormListVo> selectProTaskWorkorderReportFormList(ProTaskWorkorderReportFormListVo proReportFormListVo) {
        QueryWrapper<ProTaskWorkorderReportFormListVo> query = new QueryWrapper<ProTaskWorkorderReportFormListVo>();


        List<ProTaskWorkorderReportFormListVo> reportFormList = proTaskWorkorderMapper.selectReportFormList(query);
        for(ProTaskWorkorderReportFormListVo  reportForm:reportFormList){
            BigDecimal sum = new BigDecimal(0);
            BigDecimal sum1 = new BigDecimal(0);
            List<ProWorkOrderProcessVo> proWorkOrderProcessVos = proWorkOrderProcessMapper.selectProWorkOrderProcessByWorkOrderId(reportForm.getWorkorderId());
            //获取最后一道工序的报工合格数量
            ProWorkOrderProcessVo proWorkOrderProcessVo = proWorkOrderProcessVos.get(proWorkOrderProcessVos.size() - 1);
            ProTask task=proTaskWorkorderMapper.selectProTaskWorkorderReportForm(proWorkOrderProcessVo.getProcessId(),reportForm.getWorkorderId()) ;

            if(Objects.nonNull(task)){
                reportForm.setTaskCode(task.getTaskCode());
                reportForm.setTaskId(task.getTaskId());
                ProFeedback feedback= proFeedbackMapper.selectProFeedbackTaskIdProcessId(task.getTaskId(),task.getProcessId());
                if(Objects.nonNull(feedback)) {
                    reportForm.setTaskQuantity(feedback.getQuantityQualify());
                }
            }
            //设置进度
            for (ProWorkOrderProcessVo workOrderProcessVo : proWorkOrderProcessVos) {
                 ProTask task1 = proTaskWorkorderMapper.selectProTaskWorkorderReportForm(workOrderProcessVo.getProcessId(), reportForm.getWorkorderId());
                 if(Objects.nonNull(task1)){
                     sum = sum.add(task1.getQuantity());
                     ProFeedback feedback = proFeedbackMapper.selectProFeedbackTaskIdProcessId(task1.getTaskId(), task1.getProcessId());
                     if(Objects.nonNull(feedback)) {
                         sum1 = sum1.add(feedback.getQuantityQualify());
                     }
                 }
            }

            if(sum1.compareTo(BigDecimal.ZERO)!=0) {
                if(sum.compareTo(BigDecimal.ZERO)!=0){
                BigDecimal divide = sum1.divide(sum,5, RoundingMode.HALF_UP);
                BigDecimal bigDecimal = divide.setScale(4, RoundingMode.HALF_UP);
                reportForm.setSchedule(bigDecimal);
            } else{
                    reportForm.setSchedule(new BigDecimal(0));
                }
            }
            else{
                reportForm.setSchedule(new BigDecimal(0));
            }

        }
        return reportFormList;
    }
}
