package com.ximai.mes.pro.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.pro.domain.AppConfig;
import com.ximai.mes.pro.mapper.AppConfigMapper;
import com.ximai.mes.pro.service.IAppConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 作业端配置记录Service业务层处理
 *
 * @author generator
 * @date 2024-06-24
 */
@Service
public class AppConfigServiceImpl implements IAppConfigService {
    @Autowired
    private AppConfigMapper appConfigMapper;

    /**
     * 查询作业端配置记录
     *
     * @param id 作业端配置记录主键
     * @return 作业端配置记录
     */
    @Override
    public AppConfig selectAppConfigById(Long id) {
        return appConfigMapper.selectAppConfigById(id);
    }

    /**
     * 查询作业端配置记录列表
     *
     * @param appConfig 作业端配置记录
     * @return 作业端配置记录
     */
    @Override
    public List<AppConfig> selectAppConfigList(AppConfig appConfig) {
        return appConfigMapper.selectAppConfigList(appConfig);
    }

    /**
     * 新增作业端配置记录
     *
     * @param appConfig 作业端配置记录
     * @return 结果
     */
    @Override
    public int insertAppConfig(AppConfig appConfig) {
        List<AppConfig> lastVersion = this.selectLastVersion(appConfig.getAppName());
        //修改历史版本为非最新
        if(appConfig.getLastVersion()==0){
            lastVersion.forEach(s->{
                s.setLastVersion(1);
                s.updateAction();
                appConfigMapper.updateAppConfig(s);
            });
        }
        appConfig.createAction();
        return appConfigMapper.insertAppConfig(appConfig);
    }

    /**
     * 修改作业端配置记录
     *
     * @param appConfig 作业端配置记录
     * @return 结果
     */
    @Override
    public int updateAppConfig(AppConfig appConfig) {
        List<AppConfig> lastVersion = this.selectLastVersion(appConfig.getAppName());
        appConfig.updateAction();
        //修改历史版本为非最新
        if(appConfig.getLastVersion()==0){
            lastVersion.forEach(s->{
                s.setLastVersion(1);
                s.updateAction();
                appConfigMapper.updateAppConfig(s);
            });
        }
        return appConfigMapper.updateAppConfig(appConfig);
    }

    /**
     * 批量删除作业端配置记录
     *
     * @param ids 需要删除的作业端配置记录主键
     * @return 结果
     */
    @Override
    public int deleteAppConfigByIds(Long[] ids) {
        return appConfigMapper.deleteAppConfigByIds(ids);
    }

    /**
     * 删除作业端配置记录信息
     *
     * @param id 作业端配置记录主键
     * @return 结果
     */
    @Override
    public int deleteAppConfigById(Long id) {
        return appConfigMapper.deleteAppConfigById(id);
    }

    @Override
    public List<AppConfig> selectLastVersion(String appName) {
        QueryWrapper<AppConfig> appConfigQueryWrapper = new QueryWrapper<>();
        appConfigQueryWrapper.eq("last_version", 0);
        appConfigQueryWrapper.eq(StringUtils.isNotNull(appName), "app_name", appName);
        List<AppConfig> appConfigs = appConfigMapper.selectListByQw(appConfigQueryWrapper);
        return appConfigs;
    }
}
