package com.ximai.mes.pro.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.ProMaterialRequest;
import com.ximai.mes.pro.domain.task.ProTask;
import com.ximai.mes.pro.domain.task.ProTaskWorkunit;
import com.ximai.mes.pro.domain.vo.ProMaterialRequestItemVo;
import com.ximai.mes.pro.domain.vo.ProMaterialRequestVo;
import com.ximai.mes.pro.domain.vo.ProTaskVo;
import com.ximai.mes.pro.domain.vo.ProWorkOrderBomVo;
import com.ximai.mes.pro.domain.vo.task.MaterialRequestIds;
import com.ximai.mes.wm.domain.vo.WmIssueVo;

import java.util.List;

/**
 * 领料申请Service接口
 *
 * @author generator
 * @date 2024-02-22
 */
public interface IProMaterialRequestService {

    /**
     * 查询领料申请
     *
     * @param materialRequestId 领料申请主键
     * @return 领料申请
     */
    ProMaterialRequest selectProMaterialRequestByMaterialRequestId(Long materialRequestId);

    /**
     * 领用申请查看生产工单物料
     *
     * @param proMaterialRequestVo
     * @return
     */

    List<ProMaterialRequestItemVo> selectProMaterialRequestByMaterialRequestWorkorderId(ProMaterialRequestVo proMaterialRequestVo);

    /**
     * 查询领料申请列表
     *
     * @param proMaterialRequest 领料申请
     * @return 领料申请集合
     */
    List<ProMaterialRequest> selectProMaterialRequestList(ProMaterialRequest proMaterialRequest);
    /**
     * 查询领料申请列表
     *
     * @param query 领料申请
     * @return 领料申请集合
     */
    List<ProMaterialRequestVo> selectListVo(QueryWrapper<ProMaterialRequest> query);


    /**
     * 查询领料申请列表
     *
     * @param query 领料申请
     * @return 领料申请集合
     */
    List<ProMaterialRequest> selectList(QueryWrapper<ProMaterialRequest> query);

    /**
     * 新增领料申请
     *
     * @param proMaterialRequest 领料申请
     * @return 结果
     */
    int insertProMaterialRequest(ProMaterialRequest proMaterialRequest);

    void insertProMaterialRequest(List<ProMaterialRequest> appendList);

    /**
     * 修改领料申请
     *
     * @param proMaterialRequest 领料申请
     * @return 结果
     */
    int updateProMaterialRequest(ProMaterialRequest proMaterialRequest);


    /**
     * 修改领料申请设备、计划开始、结束时间
     *
     * @param taskWorkunit 任务派工
     * @return 结果
     */
    void updateProMaterialRequestByTaskWorkunit(ProTaskWorkunit taskWorkunit);

    /**
     * 批量删除领料申请
     *
     * @param materialRequestIds 需要删除的领料申请主键集合
     * @return 结果
     */
    int deleteProMaterialRequestByMaterialRequestIds(Long[] materialRequestIds);

    /**
     * 删除领料申请信息
     *
     * @param materialRequestId 领料申请主键
     * @return 结果
     */
    int deleteProMaterialRequestByMaterialRequestId(Long materialRequestId);

    void insertProMaterialRequestItemV2(ProTask proTaskVo);

    void insertProMaterialRequestItem(ProTaskVo proTaskVo);

    List<ProMaterialRequestVo> selectProMaterialRequestLists(QueryWrapper<ProMaterialRequest> query);

    void deleteByTaskWorknuitId(Long taskWorkunitId);


    void selectProMaterialRequestUpdateWindCaseGrantNum(WmIssueVo wm);

    void insertProMaterialRequestIssueItem(Long taskWorkunitId, ProTask proTask);

    int insertProMaterialRequestCreate(ProMaterialRequest proMaterialRequest);

    boolean checkMaterialRequestIsExist(Long taskWorkunitId);

    void checkMaterialRequest(ProTask task);

    List<ProMaterialRequestVo> selectMaterialRequestPrintTab(MaterialRequestIds materialRequestIds);

    boolean checkMaterialRequestExist(Long workunitId);

    List<ProWorkOrderBomVo> selectMaterialLists(Long taskId);

    //List<ProMaterialRequestVo> selectMaterialRequestPrintTab(materialRequestIds);
}
