package com.ximai.mes.pro.mapper.proWorkOrder;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderBom;
import com.ximai.mes.pro.domain.vo.ProWorkOrderBomVo;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 生产工单BOMMapper接口
 *
 * @author yinjinlu
 * @date 2024-01-23
 */
public interface ProWorkOrderBomMapper extends BaseMapper<ProWorkOrderBom> {
    /**
     * 根据工单id查询所有BOM
     */
    List<ProWorkOrderBom> selectBomByWorkorderCode(@Param("workorderCode") String workorderCode);

    /**
     * 查询生产工单BOM
     *
     * @param bomItemId 生产工单BOM主键
     * @return 生产工单BOM
     */
    ProWorkOrderBom selectProWorkOrderBomByBomItemId(Long bomItemId);

    /**
     * 查询生产工单BOM列表
     *
     * @param proWorkOrderBom 生产工单BOM
     * @return 生产工单BOM集合
     */
    List<ProWorkOrderBom> selectProWorkOrderBomList(ProWorkOrderBom proWorkOrderBom);

    /**
     * 新增生产工单BOM
     *
     * @param proWorkOrderBom 生产工单BOM
     * @return 结果
     */
    int insertProWorkOrderBom(ProWorkOrderBom proWorkOrderBom);

    /**
     * 修改生产工单BOM
     *
     * @param proWorkOrderBom 生产工单BOM
     * @return 结果
     */
    int updateProWorkOrderBom(ProWorkOrderBom proWorkOrderBom);

    /**
     * 删除生产工单BOM
     *
     * @param bomItemId 生产工单BOM主键
     * @return 结果
     */
    int deleteProWorkOrderBomByBomItemId(Long bomItemId);

    /**
     * 批量删除生产工单BOM
     *
     * @param bomItemIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteProWorkOrderBomByBomItemIds(Long[] bomItemIds);

    /**
     * 删除生产工单BOM
     *
     * @param workorderId 生产工单主键
     * @return 结果
     */
    int deleteByWorkorderId(Long workorderId);

    @Delete("delete from pro_work_order_bom where workorder_code = #{workorderCode}")
    void deleteByWorkorderCode(@Param("workorderCode") String workorderCode);

    @Select(value = "select DISTINCT t2.item_id,t2.item_code,t2.item_name,t2.specification,t2.item_type_name,t2.unit_of_measure from pro_work_order_bom t1 left join md_item t2 on t1.item_id = t2.item_id ${ew.customSqlSegment}")
    List<ProWorkOrderBomVo> selectProWorkOrderBomJoinItem(@Param("ew") QueryWrapper<ProWorkOrderBomVo> query);


    @Delete(value = "delete from pro_work_order_bom  ${ew.customSqlSegment}")
    void deleteProWorkOrderBom(@Param("ew") QueryWrapper<ProWorkOrderBom> queryWrapper);
}
