package com.ximai.mes.pro.dto;

import com.ximai.mes.pro.domain.proWorkOrder.ProWorkorder;
import io.swagger.annotations.ApiModelProperty;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;

/**
 * 产品序列号打印记录对象 pro_product_qrcode_record
 *
 * @author generator
 * @date 2024-08-31
 */
@Data
public class ProProductQrcodeRecordCreate {
    private static final long serialVersionUID = 1L;

    /** ID */
    @TableId
    private Long recordId;

    /** 产品ID */
    @ApiModelProperty("产品ID")
    private Long itemId;

    /** 产品编码 */
    @ApiModelProperty("产品编码")
    private String itemCode;

    /** 工单ID */
    @ApiModelProperty("工单ID")
    private Long workOrderId;

    /** 工单编号 */
    @ApiModelProperty("工单编号")
    private String workOrderNo;

    /** 打印次数 */
    @ApiModelProperty("打印次数")
    private Integer printTime;

    /** 二维码 */
    @ApiModelProperty("二维码")
    private String qrcode;

    /** 客户编码 */
    @ApiModelProperty("客户编码")
    private String clientCode;

    /** 客户名称 */
    @ApiModelProperty("客户名称")
    private String clientName;

    /** 产品描述 */
    @ApiModelProperty("产品描述")
    private String itemDesc;
    /**
     * 模板ID
     */
    private Long templateId;


    /**
     * 模板名称
     */
    private String templateName;

    /**
     * 模板编码（ID）
     */
    private String templateCode;

    private String taskBatch;
    /**
     * 模板类型
     */
    private String templateType;
    public void initByWorkorder(ProWorkorder workorder){
        this.setItemId(workorder.getProductId());
        this.setItemCode(workorder.getProductCode());
        this.setClientCode(workorder.getClientCode());
        this.setClientName(workorder.getClientName());
        this.setWorkOrderId(workorder.getWorkorderId());
        this.setWorkOrderNo(workorder.getWorkorderCode());
    }



}
