package com.ximai.mes.md.service.impl;

import cn.hutool.core.map.MapUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.mes.md.domain.MdSapDictData;
import com.ximai.mes.md.mapper.MdSapDictDataMapper;
import com.ximai.mes.md.service.IMdSapDictDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * sap特性字典数据Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-16
 */
@Service
public class MdSapDictDataServiceImpl implements IMdSapDictDataService {
    @Autowired
    private MdSapDictDataMapper mdSapDictDataMapper;

    /**
     * 查询sap特性字典数据
     *
     * @param id sap特性字典数据主键
     * @return sap特性字典数据
     */
    @Override
    public MdSapDictData selectById(String id) {
        return mdSapDictDataMapper.selectById(id);
    }

    /**
     * 查询sap特性字典数据列表
     *
     * @param mdSapDictData sap特性字典数据
     * @return sap特性字典数据
     */
    @Override
    public List<MdSapDictData> selectList(MdSapDictData mdSapDictData) {
        return mdSapDictDataMapper.selectList(mdSapDictData);
    }

    @Override
    public IPage<MdSapDictData> pageByMap(Map<String, Object> params) {
        final Integer current = MapUtil.getInt(params, "current");
        final int size = MapUtil.getInt(params, "size");
        int offset = (current - 1) * size;
        params.put("offset", offset);
        params.put("limit", size);
        final List<MdSapDictData> list = mdSapDictDataMapper.pageByMap(params);
        Integer total = mdSapDictDataMapper.countByMap(params);
        final Page<MdSapDictData> page = new Page<>();
        page.setTotal(total);
        page.setRecords(list);
        return page;
    }

    /**
     * 新增sap特性字典数据
     *
     * @param mdSapDictData sap特性字典数据
     * @return 结果
     */
    @Override
    public int insert(MdSapDictData mdSapDictData) {
        mdSapDictData.setCreateTime(DateUtils.getNowDate());
        return mdSapDictDataMapper.insert(mdSapDictData);
    }

    /**
     * 修改sap特性字典数据
     *
     * @param mdSapDictData sap特性字典数据
     * @return 结果
     */
    @Override
    public int update(MdSapDictData mdSapDictData) {
        mdSapDictData.setUpdateTime(DateUtils.getNowDate());
        return mdSapDictDataMapper.update(mdSapDictData);
    }

    /**
     * 批量删除sap特性字典数据
     *
     * @param ids 需要删除的sap特性字典数据主键
     * @return 结果
     */
    @Override
    public int deleteByIds(String[] ids) {
        return mdSapDictDataMapper.deleteByIds(ids);
    }

    /**
     * 删除sap特性字典数据信息
     *
     * @param id sap特性字典数据主键
     * @return 结果
     */
    @Override
    public int deleteById(String id) {
        return mdSapDictDataMapper.deleteById(id);
    }
}
