package com.ximai.mes.md.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.core.domain.SapResult;
import com.ximai.common.core.domain.entity.MdItemType;
import com.ximai.mes.md.domain.MdItem;
import com.ximai.mes.md.vo.ItemUpdateMesVo;
import com.ximai.mes.md.vo.MdItemVo;
import com.ximai.mes.md.vo.SapItemVo;
import com.ximai.mes.remote.dto.MdItemErpDto;

import java.io.InputStream;
import java.util.List;
import java.util.Map;

public interface IMdItemService {

    /**
     * 根据条件查询物料编码
     *
     * @param mdItem
     * @return
     */
    List<MdItemVo> selectMdItemList(MdItem mdItem);

    MdItemType getItemTypeByItemId(Long id);


    /**
     * 根据主键查询物料编码
     *
     * @param itemId
     * @return
     */
    MdItem selectMdItemById(Long itemId);


    /**
     * 检查物料编码是否唯一
     *
     * @param mdItem
     * @return
     */
    String checkItemCodeUnique(MdItem mdItem);

    List<MdItem> selectListByQw(QueryWrapper<MdItem> query);

    /**
     * 检查物料名称是否唯一
     *
     * @param mdItem
     * @return
     */
    String checkItemNameUnique(MdItem mdItem);

    /**
     * 新增物料编码
     *
     * @param mdItem
     * @return
     */
    int insertMdItem(MdItem mdItem);

    /**
     * 更新物料编码
     *
     * @param mdItem
     * @return
     */
    int updateMdItem(MdItem mdItem);


    int updateMdItems(MdItem mdItem, ItemUpdateMesVo mdItemVo);


    /**
     * 批量删除物料编码
     *
     * @param itemIds
     * @return
     */
    int deleteByItemIds(Long[] itemIds);

    /**
     * 根据主键删除物料编码
     *
     * @param itemId
     * @return
     */
    int deleteByItemId(Long itemId);

    /**
     * 根据主键转正式产品
     *
     * @param itemIds
     * @return
     */
    void becomeFormalProduct(Long[] itemIds);

    /**
     * 导入物料/产品
     *
     * @param itemList      物料/产品数据列表
     * @param updateSupport 是否更新支持，如果已存在，则进行更新数据
     * @param operaName     操作用户
     * @return 结果
     */
    void importMdItem(InputStream io, boolean updateSupport);

    int itemCreate(ItemUpdateMesVo mdItemVo);

    /**
     * 同步ERP数据
     */
    void syncErpData();

    /**
     * 同步ERP数据
     * 查询所有ERP同步标识为未同步数据，同步成功后修改为已同步
     * 每次更新1000行，直到所有数据同步完成为止
     */
    void syncEditErpData();

    /**
     * 同步ERP数据
     * 查询所有ERP同步标识为未同步数据，同步成功后修改为已同步
     * 每次更新1000行，直到所有数据同步完成为止
     */
    void syncEditErpData(MdItemErpDto itemErpDto, Map<Long, MdItemType> itemTypeMap);

    /**
     * 初始同步新增ERP数据
     */
    void initSyncAddErpData();

    List<String> selectGroupLineName();
}

