package com.ximai.mes.report.request;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ximai.common.annotation.Excel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
@Data
public class FeedbackRequest {

    /**
     * 工单类型
     */
    @ApiModelProperty(  "工单类型")
    private String workorderType;


    @ApiModelProperty("客户项目号")
    private String customerProjectNo;


    @ApiModelProperty("订单单号")
    private String orderCode;

    /**
     * 工单编码
     */
    @ApiModelProperty(  "工单编码")
    private String workorderCode;

    /**
     * 任务编号
     */
    @ApiModelProperty(  "工序任务号")
    private String taskCode;

    /**
     * 产品编号
     */
    @ApiModelProperty(  "产品编号")
    private String productCode;

    /**
     * 产品编号
     */
    @ApiModelProperty(  "产品编号")
    private String productId;

    /**
     * 产品名称
     */
    @ApiModelProperty(  "产品名称")
    private String productName;

    /**
     * 工序ID
     */
    @ApiModelProperty(  "工序ID")
    private Long processId;

    /**
     * 工序编码
     */
    @ApiModelProperty(  "工序编码")
    private String processCode;

    /**
     * 工序编码
     */
    @ApiModelProperty(  "工序名称")
    private String processName;

    /**
     * 车间ID
     */
    @ApiModelProperty("车间ID")
    private Long workshopId;
    @ApiModelProperty("车间名称")
    private String workshopName;

    /**
     * 工作中心ID
     */
    @ApiModelProperty(  "工作中心ID")
    private Long workstationId;


    /**
     * 工作中心名称
     */
    @ApiModelProperty(  "工作中心名称")
    private String workstationName;

    /**
     *
     */
    @ApiModelProperty("工作单元ID")
    private Long workunitId;

    @ApiModelProperty("作业单元名称")
    private String workunitName;



    @ApiModelProperty("报工人员名称")
    private String userName;


    @ApiModelProperty("报工人员昵称")
    private String nickName;

    @ApiModelProperty("报工开始")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date startDate;

    @ApiModelProperty("报工结束")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date endDate;

    @ApiModelProperty("是否筛查不良")
    private Boolean defectStatus;



    @ApiModelProperty("不良原因描述")
    private String abnormalReason;

    @ApiModelProperty("不良原因ID")
    private Long abnormalId;


}
