package com.ximai.mes.remote.process;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.aspect.IExtendedProcess;
import com.ximai.mes.md.domain.MdItem;
import com.ximai.mes.md.mapper.MdItemMapper;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderProcess;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkorder;
import com.ximai.mes.pro.domain.task.ProTask;
import com.ximai.mes.pro.domain.vo.ProWorkOrderProcessVo;
import com.ximai.mes.pro.dto.task.FeedbackDto;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkOrderProcessService;
import com.ximai.mes.remote.ErpService;
import com.ximai.mes.remote.dto.FinishStockInCreate;
import com.ximai.mes.remote.dto.FinishStockInCreateDetail;
import com.ximai.mes.remote.dto.ProcessTransferCreate;
import com.ximai.system.strategy.AutoCodeUtil;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@ApiOperation("工序完工转移")
@Component
public class ProcessTransferCreateProcess implements IExtendedProcess {

    @Autowired
    ErpService erpService;
    @Autowired
    IProWorkOrderProcessService workOrderProcessService;
    @Autowired
    MdItemMapper mdItemMapper;
    @Autowired
    private AutoCodeUtil autoCodeUtil;
    @Override
    public void process(Object[] args, Object returnResult) {
        FeedbackDto feedbackDto = (FeedbackDto) args[0];
        BigDecimal qualifyQuantity = (BigDecimal)args[1];
        ProcessTransferCreate create = new ProcessTransferCreate();
        create.setFromLocation(feedbackDto.getCurrTask().getWorkstationCode());
        create.setFromLocationName(feedbackDto.getCurrTask().getWorkstationName());
        create.setFromProcessSeq(feedbackDto.getCurrTask().getIdx());
        create.setFromProcessName(feedbackDto.getCurrTask().getProcessName());
        if(feedbackDto.getNextTask()!=null){
            create.setToLocation(feedbackDto.getNextTask().getWorkstationCode());
            create.setToLocationName(feedbackDto.getNextTask().getWorkstationName());
            create.setToProcessSeq(feedbackDto.getNextTask().getIdx());
            create.setToProcessName(feedbackDto.getNextTask().getProcessName());
        }
        List<ProWorkOrderProcess> workorderProcessLis = workOrderProcessService.selectListByQw(new QueryWrapper<ProWorkOrderProcess>().eq("t1.workorder_id", feedbackDto.getWorkorder().getWorkorderId()).eq("t1.process_id",feedbackDto.getCurrTask().getProcessId()));
        if(!workorderProcessLis.isEmpty() && workorderProcessLis.get(0).getStdWorkingTime()!=null){
            create.setMachineHours(workorderProcessLis.get(0).getStdWorkingTime().multiply(qualifyQuantity).intValue());
            create.setManHours(workorderProcessLis.get(0).getStdWorkingTime().multiply(qualifyQuantity).intValue());
        }
        create.setTransferQty(qualifyQuantity);
        create.setWorkOrderNo(feedbackDto.getWorkorder().getWorkorderCode());
        create.setWorkOrderType(feedbackDto.getWorkorder().getWorkorderType());
        create.setType("1");
        erpService.processTransfer(create);
    }
}
