package com.ximai.mes.pro.service.productionRequest;

import java.util.List;
import com.ximai.mes.pro.domain.productionRequest.ProProductionRequestProcess;

/**
 * 量产申请工序Service接口
 *
 * @author chicheng.li
 * @date 2024-01-22
 */
public interface IProProductionRequestProcessService
{
    /**
     * 查询量产申请工序
     *
     * @param productionRequestProcessId 量产申请工序主键
     * @return 量产申请工序
     */
    public ProProductionRequestProcess selectProProductionRequestProcessByProductionRequestProcessId(Long productionRequestProcessId);

    /**
     * 查询量产申请工序列表
     *
     * @param proProductionRequestProcess 量产申请工序
     * @return 量产申请工序集合
     */
    public List<ProProductionRequestProcess> selectProProductionRequestProcessList(ProProductionRequestProcess proProductionRequestProcess);

    /**
     * 新增量产申请工序
     *
     * @param proProductionRequestProcess 量产申请工序
     * @return 结果
     */
    public int insertProProductionRequestProcess(ProProductionRequestProcess proProductionRequestProcess);

    /**
     * 修改量产申请工序
     *
     * @param proProductionRequestProcess 量产申请工序
     * @return 结果
     */
    public int updateProProductionRequestProcess(ProProductionRequestProcess proProductionRequestProcess);

    /**
     * 批量删除量产申请工序
     *
     * @param productionRequestProcessIds 需要删除的量产申请工序主键集合
     * @return 结果
     */
    public int deleteProProductionRequestProcessByProductionRequestProcessIds(Long[] productionRequestProcessIds);

    /**
     * 删除量产申请工序信息
     *
     * @param productionRequestProcessId 量产申请工序主键
     * @return 结果
     */
    public int deleteProProductionRequestProcessByProductionRequestProcessId(Long productionRequestProcessId);
}
