package com.ximai.mes.pro.service.impl.productionMake;

import cn.hutool.core.bean.BeanUtil;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.SecurityUtils;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.md.mapper.MdColorMapper;
import com.ximai.mes.pro.domain.productionMake.*;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionBomItem;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionProcessItem;
import com.ximai.mes.pro.domain.vo.*;
import com.ximai.mes.pro.mapper.productionMake.*;
import com.ximai.mes.pro.service.productionMake.IProProductionMakeProcessQcindexService;
import com.ximai.mes.pro.service.productionMake.IProProductionMakeProcessToolService;
import com.ximai.mes.pro.service.productionMake.IProProductionMakeService;
import com.ximai.mes.pro.service.productionSolution.IProProductionSolutionService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ximai.common.utils.SecurityUtils.getUsername;

/**
 * 量产制作Service业务层处理
 *
 * @author chicheng.li
 * @date 2024-01-23
 */
@Service
public class ProProductionMakeServiceImpl implements IProProductionMakeService {
    @Autowired
    private ProProductionMakeMapper proProductionMakeMapper;
    @Autowired
    private ProProductionMakeBomMapper proProductionMakeBomMapper;
    @Autowired
    private ProProductionMakeProcessMapper proProductionMakeProcessMapper;
    @Autowired
    private ProProductionMakeProcessItemMapper proProductionMakeProcessItemMapper;
    @Autowired
    private IProProductionSolutionService proProductionSolutionService;
    @Autowired
    private MdColorMapper mdColorMapper;
    @Autowired
    private ProProductionMakeProcessToolMapper proProductionMakeProcessToolMapper;
    @Autowired
    private ProProductionMakeProcessQcindexMapper proProductionMakeProcessQcindexMapper;
    @Autowired
    private IProProductionMakeProcessToolService proProductionMakeProcessToolService;
    @Autowired
    private IProProductionMakeProcessQcindexService proProductionMakeProcessQcindexService;


    /**
     * 查询量产制作
     *
     * @param productionMakeId 量产制作主键
     * @return 量产制作
     */
    @Override
    public ProProductionMakeVo selectProProductionMakeByProductionMakeId(Long productionMakeId) {
        ProProductionMakeVo rst = proProductionMakeMapper.selectProProductionMakeByProductionMakeId(productionMakeId);
        ProProductionMakeBom proProductionMakeBom = new ProProductionMakeBom();
        proProductionMakeBom.setProductionMakeId(productionMakeId);
        List<ProProductionMakeBom> proProductionMakeBomList = proProductionMakeBomMapper.selectProProductionMakeBomList(proProductionMakeBom);
        ProProductionMakeProcess proProductionMakeProcessQuery = new ProProductionMakeProcess();
        proProductionMakeProcessQuery.setProductionMakeId(productionMakeId);
        List<ProProductionMakeProcess> proProductionMakeProcessList = proProductionMakeProcessMapper.selectProProductionMakeProcessList(proProductionMakeProcessQuery);
        List<ProProductionMakeProcessVo> processVoList = new ArrayList<ProProductionMakeProcessVo>();
        for (ProProductionMakeProcess proProductionMakeProcess : proProductionMakeProcessList) {
            ProProductionMakeProcessVo temp = new ProProductionMakeProcessVo();
            // 根据记录id获取工序明细
            ProProductionMakeProcessItem requestProcessItem = new ProProductionMakeProcessItem();
            requestProcessItem.setProductionMakeProcessId(proProductionMakeProcess.getProductionMakeProcessId());
            List<ProProductionMakeProcessItem> processItemList = proProductionMakeProcessItemMapper.selectProProductionMakeProcessItemList(requestProcessItem);
            temp.setProcessItemList(processItemList);
            BeanUtil.copyProperties(proProductionMakeProcess, temp);
            processVoList.add(temp);
        }
        rst.setBomList(proProductionMakeBomList);
        rst.setProcessList(processVoList);

        //查询工装量具
        ProProductionMakeProcessTool toolQuery = new ProProductionMakeProcessTool();
        toolQuery.setProductionMakeId(rst.getProductionMakeId());

        List<ProProductionMakeProcessToolVo> toolList = proProductionMakeProcessToolService.selectProProductionMakeProcessToolVoList(toolQuery);
        Map<Long, List<ProProductionMakeProcessToolVo>> toolMap = toolList.stream().collect(Collectors.groupingBy(s -> s.getProductionMakeProcessId()));
        //查询检验项
        ProProductionMakeProcessQcindex qcindexQuery = new ProProductionMakeProcessQcindex();
        toolQuery.setProductionMakeId(rst.getProductionMakeId());
        List<ProProductionMakeProcessQcindexVo> qcindexList = proProductionMakeProcessQcindexService.selectProProductionMakeProcessQcindexVoList(qcindexQuery);
        Map<Long, List<ProProductionMakeProcessQcindexVo>> qcindexMap = qcindexList.stream().collect(Collectors.groupingBy(s -> s.getProductionMakeProcessId()));
        for (ProProductionMakeProcessVo proProductionMakeProcess : processVoList) {
            proProductionMakeProcess.setToolList(toolMap.getOrDefault(proProductionMakeProcess.getProductionMakeProcessId(), new ArrayList<ProProductionMakeProcessToolVo>()));
            proProductionMakeProcess.setQcindexList(qcindexMap.getOrDefault(proProductionMakeProcess.getProductionMakeProcessId(), new ArrayList<ProProductionMakeProcessQcindexVo>()));

        }
        return rst;
    }

    /**
     * 查询量产制作列表
     *
     * @param proProductionMake 量产制作
     * @return 量产制作
     */
    @Override
    public List<ProProductionMakeVo> selectProProductionMakeList(ProProductionMake proProductionMake) {
        List<ProProductionMakeVo> list = proProductionMakeMapper.selectProProductionMakeList(proProductionMake);
        return list;
    }

    /**
     * 新增量产制作
     *
     * @param proProductionMakeVo 量产制作
     * @return 结果
     */
    @Override
    public int insertProProductionMake(ProProductionMakeVo proProductionMakeVo) {
        ProProductionMake proProductionMake = new ProProductionMake();
        BeanUtil.copyProperties(proProductionMakeVo, proProductionMake);
        proProductionMake.setCreateTime(DateUtils.getNowDate());
        proProductionMake.setCreateBy(getUsername());
        proProductionMake.setProductionMakeStatus(0);
        int i = proProductionMakeMapper.insertProProductionMake(proProductionMake);
        Long productionMakeId = proProductionMake.getProductionMakeId();

        // 获取打样申请BOM列表
        List<ProProductionMakeBom> bomList = proProductionMakeVo.getBomList();
        for (ProProductionMakeBom proProductionMakeBom : bomList) {
            proProductionMakeBom.setProductionMakeId(productionMakeId);
            proProductionMakeBomMapper.insertProProductionMakeBom(proProductionMakeBom);
        }

        // 获取打样工序
        List<ProProductionMakeProcessVo> processList = proProductionMakeVo.getProcessList();
        for (ProProductionMakeProcessVo proProductionMakeProcessVo : processList) {
            proProductionMakeProcessVo.setProductionMakeId(productionMakeId);
            // 保存工序
            ProProductionMakeProcess proProductionMakeProcess = proProductionMakeProcessVo.getProductionMakeProcess(proProductionMakeProcessVo);
            proProductionMakeProcessMapper.insertProProductionMakeProcess(proProductionMakeProcess);
            Long productionMakeProcessId = proProductionMakeProcess.getProductionMakeProcessId();
            // 获取工序物料-保存
            List<ProProductionMakeProcessItem> proProductionMakeProcessItems = proProductionMakeProcessVo.getProcessItemList();
            for (ProProductionMakeProcessItem proProductionMakeProcessItem : proProductionMakeProcessItems) {
                proProductionMakeProcessItem.setProductionMakeProcessId(productionMakeProcessId);
                proProductionMakeProcessItemMapper.insertProProductionMakeProcessItem(proProductionMakeProcessItem);
            }

            //检验项
            List<ProProductionMakeProcessQcindexVo> qcindexList = proProductionMakeProcessVo.getQcindexList();
            qcindexList.forEach(s -> {
                ProProductionMakeProcessQcindex temp = new ProProductionMakeProcessQcindex();
                BeanUtil.copyProperties(s, temp);
                temp.setProductionMakeId(proProductionMakeProcessVo.getProductionMakeId());
                temp.setProductionMakeProcessId(proProductionMakeProcess.getProductionMakeProcessId());
                proProductionMakeProcessQcindexMapper.insertProProductionMakeProcessQcindex(temp);
            });
            //工装量具
            List<ProProductionMakeProcessToolVo> toolList = proProductionMakeProcessVo.getToolList();
            toolList.forEach(s -> {
                ProProductionMakeProcessTool temp = new ProProductionMakeProcessTool();
                BeanUtil.copyProperties(s, temp);
                temp.setProductionMakeId(proProductionMake.getProductionMakeId());
                temp.setProductionMakeProcessId(proProductionMakeProcess.getProductionMakeProcessId());
                proProductionMakeProcessToolMapper.insertProProductionMakeProcessTool(temp);
            });
        }
        return i;
    }

    /**
     * 修改量产制作
     *
     * @param proProductionMakeVo 量产制作
     * @return 结果
     */
    @Override
    public int updateProProductionMake(ProProductionMakeVo proProductionMakeVo) {
        //更新主表
        //ProProductionMake proProductionMake = proProductionMakeMapper.selectById(proProductionMakeVo.getProductionMakeId());

        ProProductionMake proProductionMake = new ProProductionMake();
        BeanUtil.copyProperties(proProductionMakeVo, proProductionMake);
        proProductionMake.setUpdateTime(DateUtils.getNowDate());
        proProductionMake.setRemark(proProductionMakeVo.getRemark());
        int i = proProductionMakeMapper.updateById(proProductionMake);

        //更新BOM
        List<ProProductionMakeBom> bomList = proProductionMakeVo.getBomList();
        ProProductionMakeBom productionRequestBom = new ProProductionMakeBom();
        productionRequestBom.setProductionMakeId(proProductionMakeVo.getProductionMakeId());
        List<ProProductionMakeBom> dbBomList = proProductionMakeBomMapper.selectProProductionMakeBomList(productionRequestBom);
        if (bomList != null) {
            for (ProProductionMakeBom proProductionMakeBom : bomList) {
                if (proProductionMakeBom.getBomItemId() == null) {
                    proProductionMakeBom.setProductionMakeId(proProductionMake.getProductionMakeId());
                    proProductionMakeBomMapper.insertProProductionMakeBom(proProductionMakeBom);
                } else {
                    proProductionMakeBomMapper.updateProProductionMakeBom(proProductionMakeBom);
                }
            }
            dbBomList.forEach(v -> {
                if (!bomList.stream().filter(v2 -> {
                    return v.getBomItemId().equals(v2.getBomItemId());
                }).findFirst().isPresent()) {
                    proProductionMakeBomMapper.deleteProProductionMakeBomByBomItemId(v.getBomItemId());
                }
                ;
            });
        }

        // 更新工序、工序物料
        List<ProProductionMakeProcessVo> processList = proProductionMakeVo.getProcessList();
        ProProductionMakeProcess productionRequestProcess = new ProProductionMakeProcess();
        productionRequestProcess.setProductionMakeId(proProductionMakeVo.getProductionMakeId());
        List<ProProductionMakeProcess> processListDb = proProductionMakeProcessMapper.selectProProductionMakeProcessList(productionRequestProcess);
        if (processList != null) {
            for (ProProductionMakeProcessVo proProductionMakeProcessVo : processList) {
                proProductionMakeProcessVo.setProductionMakeId(proProductionMake.getProductionMakeId());
                // 保存工序
                ProProductionMakeProcess tempProcess = proProductionMakeProcessVo.getProductionMakeProcess(proProductionMakeProcessVo);
                if (tempProcess.getProductionMakeProcessId() == null) {
                    tempProcess.setProductionMakeId(proProductionMakeVo.getProductionMakeId());
                    proProductionMakeProcessMapper.insertProProductionMakeProcess(tempProcess);
                } else {
                    proProductionMakeProcessMapper.updateProProductionMakeProcess(tempProcess);
                }
                Long prototypeRequestProcessId = tempProcess.getProductionMakeProcessId();
                // 获取工序物料-保存
                List<ProProductionMakeProcessItem> proProductionMakeProcessItemList = proProductionMakeProcessVo.getProcessItemList();
                ProProductionMakeProcessItem proProductionMakeProcessItemQuery = new ProProductionMakeProcessItem();
                proProductionMakeProcessItemQuery.setProductionMakeProcessId(proProductionMakeProcessVo.getProductionMakeProcessId());
                List<ProProductionMakeProcessItem> proProductionMakeProcessItemListDb = proProductionMakeProcessItemMapper.selectProProductionMakeProcessItemList(proProductionMakeProcessItemQuery);
                for (ProProductionMakeProcessItem proProductionMakeProcessItem : proProductionMakeProcessItemList) {
                    proProductionMakeProcessItem.setProductionMakeProcessId(prototypeRequestProcessId);
                    if (proProductionMakeProcessItem.getProductionMakeProcessItemId() == null) {
                        proProductionMakeProcessItemMapper.insertProProductionMakeProcessItem(proProductionMakeProcessItem);
                    } else {
                        proProductionMakeProcessItemMapper.updateProProductionMakeProcessItem(proProductionMakeProcessItem);
                    }
                }
                proProductionMakeProcessItemListDb.forEach(v -> {
                    if (!proProductionMakeProcessItemList.stream().filter(v2 -> {
                        return v.getProductionMakeProcessItemId().equals(v2.getProductionMakeProcessItemId());
                    }).findFirst().isPresent()) {
                        proProductionMakeProcessItemMapper.deleteProProductionMakeProcessItemByProductionMakeProcessItemId(v.getProductionMakeProcessItemId());
                    }
                    ;
                });

                //检验项保存、删除
                List<ProProductionMakeProcessQcindexVo> proProductionMakeProcessQcindexList = proProductionMakeProcessVo.getQcindexList();
                ProProductionMakeProcessQcindex proProductionMakeProcessQcindexQuery = new ProProductionMakeProcessQcindex();
                proProductionMakeProcessQcindexQuery.setProductionMakeProcessId(prototypeRequestProcessId);
                List<ProProductionMakeProcessQcindex> proProductionMakeProcessQcindexListDb = proProductionMakeProcessQcindexMapper.selectProProductionMakeProcessQcindexList(proProductionMakeProcessQcindexQuery);
                for (ProProductionMakeProcessQcindexVo proProductionMakeProcessQcindexVo : proProductionMakeProcessQcindexList) {
                    ProProductionMakeProcessQcindex proProductionMakeProcessQcindex = new ProProductionMakeProcessQcindex();
                    BeanUtil.copyProperties(proProductionMakeProcessQcindexVo, proProductionMakeProcessQcindex);
                    proProductionMakeProcessQcindex.setProductionMakeId(proProductionMakeProcessVo.getProductionMakeId());
                    proProductionMakeProcessQcindex.setProductionMakeProcessId(prototypeRequestProcessId);
                    if (proProductionMakeProcessQcindex.getProductionMakeProcessQcindexId() == null) {
                        proProductionMakeProcessQcindexMapper.insertProProductionMakeProcessQcindex(proProductionMakeProcessQcindex);
                    } else {
                        proProductionMakeProcessQcindexMapper.updateProProductionMakeProcessQcindex(proProductionMakeProcessQcindex);
                    }
                }
                proProductionMakeProcessQcindexListDb.forEach(v -> {
                    if (!proProductionMakeProcessQcindexList.stream().filter(v2 -> {
                        return v.getProductionMakeProcessQcindexId().equals(v2.getProductionMakeProcessQcindexId());
                    }).findFirst().isPresent()) {
                        proProductionMakeProcessQcindexMapper.deleteProProductionMakeProcessQcindexByProductionMakeProcessQcindexId(v.getProductionMakeProcessQcindexId());
                    }
                    ;
                });
                //工装
                List<ProProductionMakeProcessToolVo> proProductionMakeProcessToolList = proProductionMakeProcessVo.getToolList();
                ProProductionMakeProcessTool proProductionMakeProcessToolQuery = new ProProductionMakeProcessTool();
                proProductionMakeProcessToolQuery.setProductionMakeProcessId(prototypeRequestProcessId);
                List<ProProductionMakeProcessTool> proProductionMakeProcessToolListDb = proProductionMakeProcessToolMapper.selectProProductionMakeProcessToolList(proProductionMakeProcessToolQuery);
                for (ProProductionMakeProcessToolVo proProductionMakeProcessToolVo : proProductionMakeProcessToolList) {
                    ProProductionMakeProcessTool proProductionMakeProcessTool = new ProProductionMakeProcessTool();
                    BeanUtil.copyProperties(proProductionMakeProcessToolVo, proProductionMakeProcessTool);
                    proProductionMakeProcessTool.setProductionMakeProcessId(prototypeRequestProcessId);
                    proProductionMakeProcessTool.setProductionMakeId(proProductionMakeProcessVo.getProductionMakeId());
                    if (proProductionMakeProcessTool.getProductionMakeProcessToolId() == null) {
                        proProductionMakeProcessToolMapper.insertProProductionMakeProcessTool(proProductionMakeProcessTool);
                    } else {
                        proProductionMakeProcessToolMapper.updateProProductionMakeProcessTool(proProductionMakeProcessTool);
                    }
                }
                proProductionMakeProcessToolListDb.forEach(v -> {
                    if (!proProductionMakeProcessToolList.stream().filter(v2 -> {
                        return v.getProductionMakeProcessToolId().equals(v2.getProductionMakeProcessToolId());
                    }).findFirst().isPresent()) {
                        proProductionMakeProcessToolMapper.deleteProProductionMakeProcessToolByProductionMakeProcessToolId(v.getProductionMakeProcessToolId());
                    }
                    ;
                });
            }
            processListDb.forEach(v -> {
                if (!processList.stream().filter(v2 -> {
                    return v.getProductionMakeProcessId().equals(v2.getProductionMakeProcessId());
                }).findFirst().isPresent()) {
                    proProductionMakeProcessMapper.deleteProProductionMakeProcessByProductionMakeProcessId(v.getProductionMakeProcessId());
                }
                ;
            });
        }
        return i;
    }

    /**
     * 批量删除量产制作
     *
     * @param productionMakeIds 需要删除的量产制作主键
     * @return 结果
     */
    @Override
    public int deleteProProductionMakeByProductionMakeIds(Long[] productionMakeIds) {
        int i = 0;
        for (Long l : productionMakeIds) {
            i += this.deleteProProductionMakeByProductionMakeId(l);
        }
        return i;
    }

    /**
     * 删除量产制作信息
     *
     * @param productionMakeId 量产制作主键
     * @return 结果
     */
    @Override
    public int deleteProProductionMakeByProductionMakeId(Long productionMakeId) {
        //删除BOM
        proProductionMakeBomMapper.deleteProProductionMakeBomByProductionMakeId(productionMakeId);
        //删除工序
        proProductionMakeProcessMapper.deleteProProductionMakeProcessByProductionMakeId(productionMakeId);
        proProductionMakeProcessItemMapper.deleteProProductionMakeProcessItemByProductionMakeId(productionMakeId);
        return proProductionMakeMapper.deleteProProductionMakeByProductionMakeId(productionMakeId);
    }

    @Override
    public int updateProProductionMakeStatus(ProProductionMake proProductionMake) {
        if (proProductionMake.getProductionMakeStatus() == 1) {
            beginMake(proProductionMake);
            proProductionMake.setIdentifyingDate(new Date());
            proProductionMake.setIdentifyingPeople(SecurityUtils.getUsername());
            proProductionMakeMapper.updateProProductionMake(proProductionMake);
        }
        return proProductionMakeMapper.updateProProductionMakeStatus(proProductionMake.getProductionMakeId(), proProductionMake.getProductionMakeStatus());
    }

    @Override
    public void beginMake(ProProductionMake proProductionMake) {

        // 获取全部信息
        ProProductionMakeVo proProductionMakeVo = this.selectProProductionMakeByProductionMakeId(proProductionMake.getProductionMakeId());
        ProProductionSolutionVo proProductionSolutionVo = new ProProductionSolutionVo();
        BeanUtil.copyProperties(proProductionMakeVo, proProductionSolutionVo);
        List<ProProductionMakeBom> bomList = proProductionMakeVo.getBomList();
        List<ProProductionMakeProcessVo> processList = proProductionMakeVo.getProcessList();

//        List<ProProductionSolutionBom> proProductionSolutionBomList = new ArrayList<>();
//        for (ProProductionMakeBom proPrototypeMakeBom : bomList) {
//            ProProductionSolutionBom proProductionSolutionBom = new ProProductionSolutionBom();
//            BeanUtil.copyProperties(proPrototypeMakeBom,proProductionSolutionBom);
//            proProductionSolutionBomList.add(proProductionSolutionBom);
//        }
//        proProductionSolutionVo.setBomList(proProductionSolutionBomList);
        if (StringUtils.isNotNull(bomList)) {
            // 创建BOM头表
            ProProductionSolutionBomHeadVo proProductionSolutionBomHeadVo = new ProProductionSolutionBomHeadVo();
            // 封装BOM行表
            List<ProProductionSolutionBomItem> proProductionSolutionBomItems = new ArrayList<>();
            for (ProProductionMakeBom proProductionMakeBom : bomList) {
                ProProductionSolutionBomItem proProductionSolutionBomItem = new ProProductionSolutionBomItem();
                BeanUtils.copyProperties(proProductionMakeBom, proProductionSolutionBomItem);
                proProductionSolutionBomItems.add(proProductionSolutionBomItem);
            }
            proProductionSolutionBomHeadVo.setBomItemList(proProductionSolutionBomItems);
            proProductionSolutionVo.setBomHead(proProductionSolutionBomHeadVo);
        }

        List<ProProductionSolutionProcessVo> proProductionSolutionProcessVoList = new ArrayList<>();
        for (ProProductionMakeProcessVo proPrototypeMakeProcessVo : processList) {
            ProProductionSolutionProcessVo proProductionSolutionProcessVo = new ProProductionSolutionProcessVo();
            BeanUtil.copyProperties(proPrototypeMakeProcessVo, proProductionSolutionProcessVo);

            List<ProProductionMakeProcessItem> processItemList = proPrototypeMakeProcessVo.getProcessItemList();
            List<ProProductionSolutionProcessItem> proProductionSolutionProcessItems = new ArrayList<>();
            for (ProProductionMakeProcessItem proPrototypeMakeProcessItem : processItemList) {
                ProProductionSolutionProcessItem proProductionSolutionProcessItem = new ProProductionSolutionProcessItem();
                BeanUtil.copyProperties(proPrototypeMakeProcessItem, proProductionSolutionProcessItem);
                proProductionSolutionProcessItems.add(proProductionSolutionProcessItem);
            }
            proProductionSolutionProcessVo.setProcessItemList(proProductionSolutionProcessItems);
            //质检项
            List<ProProductionMakeProcessQcindexVo> processQcindexList = proPrototypeMakeProcessVo.getQcindexList();
            List<ProProductionSolutionProcessQcindexVo> proProductionSolutionProcessQcindexList = new ArrayList<ProProductionSolutionProcessQcindexVo>();
            for (ProProductionMakeProcessQcindexVo qcindexVo : processQcindexList) {
                ProProductionSolutionProcessQcindexVo proProductionSolutionProcessQcindex = new ProProductionSolutionProcessQcindexVo();
                BeanUtil.copyProperties(qcindexVo, proProductionSolutionProcessQcindex);
                proProductionSolutionProcessQcindexList.add(proProductionSolutionProcessQcindex);
            }
            proProductionSolutionProcessVo.setQcindexList(proProductionSolutionProcessQcindexList);
            //工装量具
            List<ProProductionMakeProcessToolVo> processToolList = proPrototypeMakeProcessVo.getToolList();
            List<ProProductionSolutionProcessToolVo> proProductionSolutionProcessToolList = new ArrayList<ProProductionSolutionProcessToolVo>();
            for (ProProductionMakeProcessToolVo toolVo : processToolList) {
                ProProductionSolutionProcessToolVo productionSolutionProcessToolVo = new ProProductionSolutionProcessToolVo();
                BeanUtil.copyProperties(toolVo, productionSolutionProcessToolVo);
                proProductionSolutionProcessToolList.add(productionSolutionProcessToolVo);
            }
            proProductionSolutionProcessVo.setToolList(proProductionSolutionProcessToolList);
            proProductionSolutionProcessVoList.add(proProductionSolutionProcessVo);
        }
        proProductionSolutionVo.setProcessList(proProductionSolutionProcessVoList);
        proProductionSolutionVo.setUsageId(2L);
        proProductionSolutionVo.setUsageName("量产");
        // 生成生产版本
        proProductionSolutionService.insertProProductionSolution(proProductionSolutionVo);

    }

}
