package com.ximai.mes.pro.domain.sap;

import com.alibaba.fastjson.annotation.JSONField;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 来料检验单对象 qc_iqc
 *
 * @date 2022-05-19
 */
@Data
public class SAPQcIqc extends BaseEntity {
    private static final long serialVersionUID = 1L;
    /**
     * 工单状态
     */
    @JSONField(name = "ZSTATUS")
    private String actionType;

    /**
     * 来料检验单编号
     */
    @Excel(name = "来料检验单编号")
    private String iqcCode;

    /**
     * 来料检验单名称
     */
    @Excel(name = "来料检验单名称")
    private String iqcName;

    /**
     * 检验模板ID
     */
    @Excel(name = "检验模板ID")
    private Long templateId;

    private Long sourceDocId;

    @Excel(name = "来源单据类型")
    private String sourceDocType;

    @Excel(name = "来源单据编号")
    private String sourceDocCode;

    private Long sourceLineId;


    /**
     * 供应商ID
     */
    @Excel(name = "供应商ID")
    private Long vendorId;

    /**
     * 供应商编码
     */
    @Excel(name = "供应商编码")
    private String vendorCode;

    /**
     * 供应商名称
     */
    @Excel(name = "供应商名称")
    private String vendorName;

    /**
     * 供应商简称
     */
    @Excel(name = "供应商简称")
    private String vendorNick;

    /**
     * 供应商批次号
     */
    @Excel(name = "供应商批次号")
    private String vendorBatch;

    /**
     * 产品物料ID
     */
    @Excel(name = "产品物料ID")
    private Long itemId;


    /**
     * 产品物料分类ID
     */
    @Excel(name = "产品物料ID")
    private Long itemTypeId;

    /**
     * 产品物料编码
     */
    @Excel(name = "产品物料编码")
    private String itemCode;

    /**
     * 产品物料名称
     */
    @Excel(name = "产品物料名称")
    private String itemName;

    /**
     * 规格型号
     */
    @Excel(name = "规格型号")
    private String specification;

    /**
     * 单位
     */
    @Excel(name = "单位")
    private String unitOfMeasure;

    /**
     * 最低检测数
     */
    @Excel(name = "最低检测数")
    private Long quantityMinCheck;

    /**
     * 最大不合格数
     */
    @Excel(name = "最大不合格数")
    private Long quantityMaxUnqualified;

    /**
     * 本次接收数量
     */
    @Excel(name = "本次接收数量")
    private BigDecimal quantityRecived;

    /**
     * 本次检测数量
     */
    @Excel(name = "本次检测数量")
    private Long quantityCheck;

    /**
     * 不合格数
     */
    @Excel(name = "不合格数")
    private Long quantityUnqualified;

    /**
     * 致命缺陷率
     */
    @Excel(name = "致命缺陷率")
    private BigDecimal crRate;

    /**
     * 严重缺陷率
     */
    @Excel(name = "严重缺陷率")
    private BigDecimal majRate;

    /**
     * 轻微缺陷率
     */
    @Excel(name = "轻微缺陷率")
    private BigDecimal minRate;

    /**
     * 致命缺陷数量
     */
    @Excel(name = "致命缺陷数量")
    private Long crQuantity;

    /**
     * 严重缺陷数量
     */
    @Excel(name = "严重缺陷数量")
    private Long majQuantity;

    /**
     * 轻微缺陷数量
     */
    @Excel(name = "轻微缺陷数量")
    private Long minQuantity;

    /**
     * 检测结果
     */
    @Excel(name = "检测结果")
    private String checkResult;

    /**
     * 来料日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "来料日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date reciveDate;

    /**
     * 检测日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "检测日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date inspectDate;

    /**
     * 检测人员
     */
    @Excel(name = "检测人员")
    private String inspector;

    private String inspectorName;

    /**
     * 单据状态
     */
    @Excel(name = "单据状态")
    private String status;

}
