package com.ximai.mes.pro.domain.proWorkOrder;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * 生产工单工序物料对象 pro_work_order_process_item
 *
 * @author yinjinlu
 * @date 2024-01-23
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ProWorkOrderProcessItem extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @TableId
    private Long workorderProcessItemId;

    /**
     * 生产工单工序ID
     */
    @Excel(name = "生产工单工序ID")
    private Long workorderProcessId;

    /**
     * 生产工单工序ID
     */
    @Excel(name = "生产工单工序Code")
    private String workorderProcessCode;

    /**
     * 产品物料ID
     */
    @Excel(name = "产品物料ID")
    private Long itemId;
    @TableField(exist = false)
    private String itemCode;
    @TableField(exist = false)
    private String itemName;
    @TableField(exist = false)
    private String itemTypeName;
    @TableField(exist = false)
    private String processName;
    @TableField(exist = false)
    private String processCode;

    private String bomId;
    /**
     * 单位
     */
    @Excel(name = "单位")
    private String unitOfMeasure;

    /**
     * 组件数量
     */
    @Excel(name = "组件数量")
    private BigDecimal quantity;

    /**
     * SAP物料编号
     */
    @Excel(name = "SAP物料编号")
    private String sapItemCode;

    /**
     * 预留/相关需求的编号
     */
    @Excel(name = "预留/相关需求的编号")
    private String requirementNumber;

    /**
     * 预留/相关需求的项目编号
     */
    @Excel(name = "预留/相关需求的项目编号")
    private String requirementProjectNumber;

    /**
     * 存储地点
     */
    @Excel(name = "存储地点")
    private String storeAddr;

    /**
     * 报废百分比
     */
    @Excel(name = "报废百分比")
    private BigDecimal scrapPercentage;

    /**
     * 单位用量
     */
    @Excel(name = "单位用量")
    private String unitUsage;

    /**
     * 虚拟项目标识
     */
    @Excel(name = "虚拟项目标识")
    private String virtualProjectLog;

    /**
     * 副单位
     */
    @Excel(name = "副单位")
    private String deputyUnitOfMeasure;

    /**
     * 主副单位转换比例
     */
    @Excel(name = "主副单位转换比例")
    private BigDecimal unitConvert;

    /**
     * 存储地点
     */
    @Excel(name = "存储地点")
    private String storeAddr2;

    /**
     * BOM编号
     */
    @Excel(name = "BOM编号")
    private String processRef;

    /**
     * 是否倒冲
     */
    @Excel(name = "是否倒冲")
    private String isBackflush;

}
