package com.ximai.mes.od.service.impl;

import com.ximai.common.utils.data.DateUtils;
import com.ximai.mes.od.domain.OdSalesOrderDetail;
import com.ximai.mes.od.mapper.OdSalesOrderDetailMapper;
import com.ximai.mes.od.service.IOdSalesOrderDetailService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 销售订单详情Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-18
 */
@Service
public class OdSalesOrderDetailServiceImpl implements IOdSalesOrderDetailService {
    @Autowired
    private OdSalesOrderDetailMapper odSalesOrderDetailMapper;

    /**
     * 查询销售订单详情
     *
     * @param id 销售订单详情主键
     * @return 销售订单详情
     */
    @Override
    public OdSalesOrderDetail selectOdSalesOrderDetailById(String id) {
        return odSalesOrderDetailMapper.selectOdSalesOrderDetailById(id);
    }

    /**
     * 查询销售订单详情列表
     *
     * @param odSalesOrderDetail 销售订单详情
     * @return 销售订单详情
     */
    @Override
    public List<OdSalesOrderDetail> selectOdSalesOrderDetailList(OdSalesOrderDetail odSalesOrderDetail) {
        return odSalesOrderDetailMapper.selectOdSalesOrderDetailList(odSalesOrderDetail);
    }

    /**
     * 新增销售订单详情
     *
     * @param odSalesOrderDetail 销售订单详情
     * @return 结果
     */
    @Override
    public int insertOdSalesOrderDetail(OdSalesOrderDetail odSalesOrderDetail) {
        odSalesOrderDetail.setCreateTime(DateUtils.getNowDate());
        return odSalesOrderDetailMapper.insertOdSalesOrderDetail(odSalesOrderDetail);
    }

    /**
     * 修改销售订单详情
     *
     * @param odSalesOrderDetail 销售订单详情
     * @return 结果
     */
    @Override
    public int updateOdSalesOrderDetail(OdSalesOrderDetail odSalesOrderDetail) {
        odSalesOrderDetail.setUpdateTime(DateUtils.getNowDate());
        return odSalesOrderDetailMapper.updateOdSalesOrderDetail(odSalesOrderDetail);
    }

    /**
     * 批量删除销售订单详情
     *
     * @param ids 需要删除的销售订单详情主键
     * @return 结果
     */
    @Override
    public int deleteOdSalesOrderDetailByIds(String[] ids) {
        return odSalesOrderDetailMapper.deleteOdSalesOrderDetailByIds(ids);
    }

    /**
     * 删除销售订单详情信息
     *
     * @param id 销售订单详情主键
     * @return 结果
     */
    @Override
    public int deleteOdSalesOrderDetailById(String id) {
        return odSalesOrderDetailMapper.deleteOdSalesOrderDetailById(id);
    }
}
