package com.ximai.mes.md.service;

import java.util.List;
import com.ximai.mes.md.domain.MdProductLook;

/**
 * 产品外观Service接口
 *
 * @author yinjinlu
 * @date 2024-01-17
 */
public interface IMdProductLookService
{
    /**
     * 查询产品外观
     *
     * @param itemId 产品外观主键
     * @return 产品外观
     */
    public MdProductLook selectMdProductLookByItemId(Long itemId);

    /**
     * 查询产品外观列表
     *
     * @param mdProductLook 产品外观
     * @return 产品外观集合
     */
    public List<MdProductLook> selectMdProductLookList(MdProductLook mdProductLook);

    /**
     * 新增产品外观
     *
     * @param mdProductLook 产品外观
     * @return 结果
     */
    public int insertMdProductLook(MdProductLook mdProductLook);

    /**
     * 修改产品外观
     *
     * @param mdProductLook 产品外观
     * @return 结果
     */
    public int updateMdProductLook(MdProductLook mdProductLook);

    /**
     * 批量删除产品外观
     *
     * @param itemIds 需要删除的产品外观主键集合
     * @return 结果
     */
    public int deleteMdProductLookByItemIds(Long[] itemIds);

    /**
     * 删除产品外观信息
     *
     * @param itemId 产品外观主键
     * @return 结果
     */
    public int deleteMdProductLookByItemId(Long itemId);
}
