package com.ximai.mes.md.domain;

import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 车间对象 md_workshop
 *
 * @date 2022-05-07
 */
@Data
public class MdWorkshop extends BaseEntity {
    private static final long serialVersionUID = 1L;
 
    /**
     * 车间ID
     */
    private Long workshopId;

    /**
     * 车间编码
     */
    @Excel(name = "车间编码")
    private String workshopCode;

    /**
     * 车间名称
     */
    @Excel(name = "车间名称")
    private String workshopName;

    /**
     * 工厂ID
     */
    private Long factoryId;


    /**
     * 工厂编码
     */
    private String factoryCode;

    /**
     * 面积
     */
    @Excel(name = "面积")
    private BigDecimal area;

    /**
     * 负责人
     */
    @Excel(name = "负责人")
    private String charge;

    /**
     * 是否启用
     */
    @Excel(name = "是否启用")
    private String enableFlag;

    /**
     * 预留字段1
     */
    private String attr1;

    /**
     * 预留字段2
     */
    private String attr2;

    /**
     * 预留字段3
     */
    private Long attr3;

    /**
     * 预留字段4
     */
    private Long attr4;


}
