package com.ximai.common.utils.excel.converter;

import com.alibaba.excel.enums.BooleanEnum;

import java.lang.annotation.*;

/**
 * Convert date format.
 *
 * <p>
 * write: It can be used on classes {@link java.util.Date}
 * <p>
 * read: It can be used on classes {@link String}
 *
 * @author Jiaju Zhuang
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
@Inherited
public @interface StaticDataMappingFormat {

    /**
     *
     * 数据库值
     * @return Format pattern
     */
    String[] value() default "";

    /**
     * excel显示值
     *
     * @return True if date uses 1904 windowing, or false if using 1900 date windowing.
     */
    String[] excelValue() default "";
}
