package com.ximai.mes.tm.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.utils.data.DataUtil;
import com.ximai.mes.constant.TmToolMachineTypeEnum;
import com.ximai.mes.constant.TmToolStatusEnum;
import com.ximai.mes.tm.domain.*;
import com.ximai.mes.tm.mapper.*;
import com.ximai.mes.tm.service.ITmToolMachinesService;
import com.ximai.mes.tm.service.ITmToolRequestUseItemService;
import com.ximai.mes.tm.service.ITmToolRequestUseService;
import com.ximai.mes.tm.service.ITmToolService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 刀模版领用单Service业务层处理
 *
 * @author generator
 * @date 2024-02-02
 */
@Service
public class TmToolRequestUseServiceImpl implements ITmToolRequestUseService {
    @Autowired
    private TmToolRequestUseMapper tmToolRequestUseMapper;

    @Autowired
    private TmToolRequestMapper tmToolRequestMapper;

    @Autowired
    private TmToolRequestUseItemMapper tmToolRequestUseItemMapper;

    @Autowired
    private ITmToolRequestUseItemService tmToolRequestUseItemService;

    @Autowired
    private TmToolRequestItemMapper tmToolRequestItemMapper;

    @Autowired
    private TmToolMapper tmToolMapper;

    @Autowired
    private ITmToolService tmToolService;

    @Autowired
    private ITmToolMachinesService tmToolMachinesService;

    @Autowired
    private ITmToolRequestUseService tmToolRequestUseService;

    /**
     * 查询刀模版领用单
     *
     * @param toolRequestUseId 刀模版领用单主键
     * @return 刀模版领用单
     */
    @Override
    public TmToolRequestUse selectTmToolRequestUseByToolRequestUseId(Long toolRequestUseId) {
        TmToolRequestUse tmToolRequestUse = tmToolRequestUseMapper.selectTmToolRequestUseByToolRequestUseId(toolRequestUseId);
        //封装子表数据
        TmToolRequestUseItem items = new TmToolRequestUseItem();
        items.setToolRequestUseId(toolRequestUseId);
        List<TmToolRequestUseItem> tmToolRequestUseItemList = tmToolRequestUseItemMapper.selectTmToolRequestUseItemList(items);

//        for (TmToolRequestUseItem tmToolRequestUseItem : tmToolRequestUseItemList) {
//            Long processId = tmToolRequestUseItem.getProcessId();
//            Long taskWorkunitId = tmToolRequestUseItem.getTaskWorkunitId();
//
//
//        }
        tmToolRequestUse.setTmToolRequestUseItemList(tmToolRequestUseItemList);
        return tmToolRequestUse;
    }

    /**
     * 查询刀模版领用单列表
     *
     * @param tmToolRequestUse 刀模版领用单
     * @return 刀模版领用单
     */
    @Override
    public List<TmToolRequestUse> selectTmToolRequestUseList(TmToolRequestUse tmToolRequestUse) {
        return tmToolRequestUseMapper.selectTmToolRequestUseList(tmToolRequestUse);
    }


    @Override
    public int insertTmToolRequestUse(TmToolRequestUse tmToolRequestUse) {
        tmToolRequestUse.createAction();
        return tmToolRequestUseMapper.insertTmToolRequestUse(tmToolRequestUse);
    }

    @Override
    public int updateTmToolRequestUse(TmToolRequestUse tmToolRequestUse) {
        tmToolRequestUse.updateAction();
        return tmToolRequestUseMapper.updateTmToolRequestUse(tmToolRequestUse);
    }

    /**
     * 新增刀模版领用单
     *
     * @param tmToolRequestUse 刀模版领用单
     * @return 结果
     */
    @Transactional
    @Override
    public int insertObj(TmToolRequestUse tmToolRequestUse) {

        List<TmToolRequestItem> tmToolRequestItemList = tmToolRequestUse.getTmToolRequestItemList();
        if (tmToolRequestItemList == null || tmToolRequestItemList.size() == 0) {
            throw new RuntimeException("刀模版领料单,申请单无刀具模板信息,不可保存");
        }

        long count = tmToolRequestItemList.stream().filter(x -> x.getTmToolList().size() > 0 && x.getTmToolList().get(0).getToolCode() != null && !Objects.equals(x.getTmToolList().get(0).getToolCode(), "")).count();
        if (count == 0) {
            throw new RuntimeException("刀模版领料单,申请单没有绑定工具需要绑定");
        }

        // 1.将申请单的信息回填到领用单生成主表数据
        TmToolRequest tmToolRequest = tmToolRequestMapper.selectTmToolRequestByToolRequestId(tmToolRequestUse.getToolRequestId());
        tmToolRequestUse.setToolRequestId(tmToolRequest.getToolRequestId());
        tmToolRequestUse.setProcessId(tmToolRequest.getProcessId());
        tmToolRequestUse.setArrangeCode(tmToolRequest.getArrangeCode());
        tmToolRequestUse.setWorkunitId(tmToolRequest.getWorkunitId());
        tmToolRequestUse.setRequestDate(tmToolRequest.getRequestDate());
        tmToolRequestUse.setStartTime(tmToolRequest.getStartTime());
        tmToolRequestUse.setEndTime(tmToolRequest.getEndTime());
        tmToolRequestUse.setRequestNum(tmToolRequest.getRequestNum());

        int i = this.insertTmToolRequestUse(tmToolRequestUse);
        Long toolRequestUseId = tmToolRequestUse.getToolRequestUseId();

        // 2.将申请单的工装夹具信息封装到领用单子表生成子表数据
        List<TmToolRequestUseItem> tmToolRequestUseItems = new ArrayList<>();
        for (TmToolRequestItem tmToolRequestItem : tmToolRequestItemList) {
            List<TmTool> tmToolList = tmToolRequestItem.getTmToolList();
            if (CollectionUtil.isNotEmpty(tmToolList)) {
                for (TmTool tmTool : tmToolList) {
                    TmToolRequestUseItem tmToolRequestUseItem = new TmToolRequestUseItem();
                    tmToolRequestUseItem.setLocation(tmTool.getLocation());
                    tmToolRequestUseItem.setToolRequestUseId(toolRequestUseId);
                    tmToolRequestUseItem.setItemId(tmToolRequestItem.getItemId());
                    tmToolRequestUseItem.setToolId(tmTool.getToolId());
                    tmToolRequestUseItem.setToolCode(tmTool.getToolCode());
                    tmToolRequestUseItem.setProcessId(tmToolRequest.getProcessId());
                    tmToolRequestUseItem.setQuantity(1);

                    tmToolRequestUseItemService.insertTmToolRequestUseItem(tmToolRequestUseItem);

                    //将tool数据状态改为已领用
                    tmTool.setStatus(TmToolStatusEnum.ISSUE.getStatus());
                    tmTool.setQuantityAvail(0L);
                    tmToolService.updateTmTool(tmTool);
                    tmToolRequestUseItems.add(tmToolRequestUseItem);

                }
            }
        }

        QueryWrapper<TmToolMachines> objectQueryWrapper = new QueryWrapper<>();
        objectQueryWrapper.eq("t1.task_workunit_id", tmToolRequest.getTaskWorkunitId());
        objectQueryWrapper.eq("t1.arrange_code", tmToolRequest.getArrangeCode());
        List<TmToolMachines> tmToolMachinesList = tmToolMachinesService.selectListByQw(objectQueryWrapper);
        if (CollectionUtil.isEmpty(tmToolMachinesList)) {
            tmToolMachinesList = tmToolMachinesService.insertObj(tmToolRequest.getTaskWorkunitId());
            tmToolMachinesService.insertTmToolMachines(tmToolMachinesList);
        }

        List<TmToolMachines> tmToolMachines = tmToolMachinesList.stream().filter(x -> x.getToolRequestUseItemId() == null).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(tmToolMachines)) {
            Deque<TmToolMachines> tmToolMachinesQueue = new ArrayDeque<>(tmToolMachines);
            for (TmToolRequestUseItem tmToolRequestUseItem : tmToolRequestUseItems) {
                TmToolMachines machines = tmToolMachinesQueue.peek();
                Integer bonding = tmToolMachinesService.bindTool(machines, tmToolRequestUseItem, TmToolMachineTypeEnum.INIT.getType());
                if (bonding > 0) {
                    tmToolMachinesQueue.poll();
                }
            }
        }
        return i;
    }

    public static void main(String[] args) {
        Queue<String> queue = new ArrayDeque<>();

        // 入队操作
        queue.offer("A");
        queue.offer("B");
        queue.offer("C");

        // 查看队首元素
        System.out.println("队首元素: " + queue.peek());

        // 出队操作
        System.out.println("移除队首元素: " + queue.poll());
//        System.out.println("移除队首元素: " + queue.poll());

        // 再次查看队首元素
        System.out.println("队首元素: " + queue.peek());
        System.out.println("队首元素 数量: " + queue.size());
        System.out.println("队首元素 对象: " + JSON.toJSONString(queue));
    }

    /**
     * 修改刀模版领用单
     *
     * @param tmToolRequestUse 刀模版领用单
     * @return 结果
     */
    @Transactional
    @Override
    public int updateObj(TmToolRequestUse tmToolRequestUse) {
        List<TmToolRequestItem> tmToolRequestItemList = tmToolRequestUse.getTmToolRequestItemList();
        if (CollectionUtil.isEmpty(tmToolRequestItemList)) {
            throw new RuntimeException("当前申请单工序没有道具，无需领料");
        }

        //1.修改主表数据
        int i = this.updateTmToolRequestUse(tmToolRequestUse);
        Long toolRequestUseId = tmToolRequestUse.getToolRequestUseId();


        //2.删除附表数据
        List<TmToolRequestUseItem> tmToolRequestUseItemList = tmToolRequestUseItemMapper.selectTmToolRequestUseItemList(new TmToolRequestUseItem(toolRequestUseId));
        if (CollectionUtil.isNotEmpty(tmToolRequestUseItemList)) {
            for (TmToolRequestUseItem tmToolRequestUseItem : tmToolRequestUseItemList) {
                tmToolRequestUseItemMapper.deleteTmToolRequestUseItemByToolRequestUseItemId(tmToolRequestUseItem.getToolRequestUseItemId());
            }
        }

        //3.将申请单的工装夹具信息封装到领用单子表生成子表数据
        for (TmToolRequestItem tmToolRequestItem : tmToolRequestItemList) {
            List<TmTool> tmToolList = tmToolRequestItem.getTmToolList();
            Long itemId = tmToolRequestItem.getItemId();
            if (CollectionUtil.isNotEmpty(tmToolList)) {
                for (TmTool tmTool : tmToolList) {
                    TmToolRequestUseItem tmToolRequestUseItem = new TmToolRequestUseItem();
                    tmToolRequestUseItem.setLocation(tmTool.getLocation());
                    tmToolRequestUseItem.setToolRequestUseId(toolRequestUseId);
                    tmToolRequestUseItem.setItemId(itemId);
                    tmToolRequestUseItem.setToolId(tmTool.getToolId());
                    tmToolRequestUseItemService.insertTmToolRequestUseItem(tmToolRequestUseItem);
                    //将tool数据状态改为已领用
                    tmTool.setStatus(TmToolStatusEnum.ISSUE.getStatus());
                    tmToolService.updateTmTool(tmTool);
                }
            }
        }
        return i;
    }

    /**
     * 批量删除刀模版领用单
     *
     * @param toolRequestUseIds 需要删除的刀模版领用单主键
     * @return 结果
     */
    @Override
    public int deleteTmToolRequestUseByToolRequestUseIds(Long[] toolRequestUseIds) {
        //删除子表数据
        tmToolRequestUseItemMapper.deleteTmToolRequestUseItemByToolRequestUseIds(toolRequestUseIds);
        return tmToolRequestUseMapper.deleteTmToolRequestUseByToolRequestUseIds(toolRequestUseIds);
    }

    /**
     * 删除刀模版领用单信息
     *
     * @param toolRequestUseId 刀模版领用单主键
     * @return 结果
     */
    @Override
    public int deleteTmToolRequestUseByToolRequestUseId(Long toolRequestUseId) {
        return tmToolRequestUseMapper.deleteTmToolRequestUseByToolRequestUseId(toolRequestUseId);
    }

    /**
     * 通过申请单id获取领用单勾选工装夹具列表
     *
     * @param toolRequestId 刀模版领用单
     * @return
     */
    @Override
    public List<TmToolRequestItem> selectTmToolsByToolRequestId(Long toolRequestId) {
        List<TmToolRequestItem> tmToolRequestItemList = tmToolRequestItemMapper.selectTmToolRequestItemList(new TmToolRequestItem(toolRequestId));

        QueryWrapper<TmToolRequest> tmToolRequestQueryWrapper = new QueryWrapper<>();
        tmToolRequestQueryWrapper.eq("tool_request_id", toolRequestId);
        List<TmToolRequest> tmToolRequests = tmToolRequestMapper.selectListByQw(tmToolRequestQueryWrapper);
        TmToolRequest tmToolRequest = tmToolRequests.get(0);

        if (CollectionUtil.isNotEmpty(tmToolRequestItemList)) {
            for (TmToolRequestItem tmToolRequestItem : tmToolRequestItemList) {
                tmToolRequestItem.setEstimatedLifeTime(DataUtil.getNormalData(tmToolRequest.getEstimatedLifeTime()));

                QueryWrapper<TmTool> tmToolQueryWrapper = new QueryWrapper<>();
                tmToolQueryWrapper.eq("item_id", tmToolRequestItem.getItemId());
                List<TmTool> tmToolList = tmToolMapper.selectListByQw(tmToolQueryWrapper);
                for (TmTool tmTool : tmToolList) {
                }
                tmToolRequestItem.setTmToolList(tmToolList);
            }
        }
        return tmToolRequestItemList;
    }

    /**
     * 通过申请单id获取领用单勾选工装夹具列表
     *
     * @param tmToolRequestUse 刀模版领用单
     * @return
     */
    @Override
    public List<TmToolRequestUseItem> getToolsByProcessIdAndArrangeCode(TmToolRequestUse tmToolRequestUse) {
        TmToolRequestUse tmToolRequestUseCondition = new TmToolRequestUse();
//        tmToolRequestUseCondition.setArrangeCode(tmToolRequestUse.getArrangeCode());
//        tmToolRequestUseCondition.setProcessId(tmToolRequestUse.getProcessId());
//        tmToolRequestUseCondition.setWorkunitId(tmToolRequestUse.getWorkunitId());
        tmToolRequestUseCondition.setTaskWorkunitId(tmToolRequestUse.getTaskWorkunitId());
        List<TmToolRequestUse> tmToolRequestUseList = tmToolRequestUseMapper.selectTmToolRequestUseList(tmToolRequestUseCondition);
        if (CollectionUtil.isEmpty(tmToolRequestUseList)) {
            return null;
        }


        List<TmToolRequestUseItem> items = new ArrayList<>();
        for (TmToolRequestUse tmToolRequestUsePo : tmToolRequestUseList) {
            //封装子表数据
            TmToolRequestUseItem tmToolRequestUseItemCondition = new TmToolRequestUseItem();
            tmToolRequestUseItemCondition.setToolRequestUseId(tmToolRequestUsePo.getToolRequestUseId());
            List<TmToolRequestUseItem> tmToolRequestUseItemList = tmToolRequestUseItemMapper.selectTmToolRequestUseItemList(tmToolRequestUseItemCondition);
            tmToolRequestUsePo.setTmToolRequestUseItemList(tmToolRequestUseItemList);
            items.addAll(tmToolRequestUseItemList);
        }

        return items;
    }
}
