package com.ximai.mes.tm.service;

import com.ximai.mes.pro.domain.sap.SAPDtoTmToolBody;
import com.ximai.mes.tm.domain.TmTool;

import java.util.List;

/**
 * 工装夹具清单Service接口
 *
 * @date 2022-05-11
 */
public interface ITmToolService {
    /**
     * 查询工装夹具清单
     *
     * @param toolId 工装夹具清单主键
     * @return 工装夹具清单
     */
    TmTool selectTmToolByToolId(Long toolId);

    /**
     * 查询工装夹具清单列表
     *
     * @param tmTool 工装夹具清单
     * @return 工装夹具清单集合
     */
    List<TmTool> selectTmToolList(TmTool tmTool);

    List<TmTool> selectDownMachineTmToolById(TmTool tmTool);

    String checkToolCodeUnique(TmTool tmTool);

    /**
     * 新增工装夹具清单
     *
     * @param tmTool 工装夹具清单
     * @return 结果
     */
    int insertTmTool(TmTool tmTool);

    /**
     * 修改工装夹具清单
     *
     * @param tmTool 工装夹具清单
     * @return 结果
     */
    int updateTmTool(TmTool tmTool);

    /**
     * 批量删除工装夹具清单
     *
     * @param toolIds 需要删除的工装夹具清单主键集合
     * @return 结果
     */
    int deleteTmToolByToolIds(Long[] toolIds);

    /**
     * 删除工装夹具清单信息
     *
     * @param toolId 工装夹具清单主键
     * @return 结果
     */
    int deleteTmToolByToolId(Long toolId);

    int deleteTmToolByToolCode(String toolCode);

    int insertObj(SAPDtoTmToolBody sapDtoTmToolBody);
}
