package com.ximai.mes.tm.controller;

import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ximai.common.utils.data.DateUtils;
import com.ximai.mes.tm.domain.TmToolMaintenance;
import com.ximai.mes.tm.service.ITmToolMaintenanceService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 要维护刀模版Controller
 *
 * @author generator
 * @date 2024-02-02
 */
@RestController
@RequestMapping("/md/maintenance")
public class TmToolMaintenanceController extends BaseController
{
    @Autowired
    private ITmToolMaintenanceService tmToolMaintenanceService;



    /**
     * 查询要维护刀模版列表
     */
    @PreAuthorize("@ss.hasPermi('md:maintenance:list')")
    @GetMapping("/list")
    public TableDataInfo list(TmToolMaintenance tmToolMaintenance)
    {
        if(tmToolMaintenance.getToolMaintenanceCode()==null
                && tmToolMaintenance.getMaintenanceStatus()==null
                && tmToolMaintenance.getItemCode()==null
                && tmToolMaintenance.getToolName()==null
                && tmToolMaintenance.getToolCode()==null
                && tmToolMaintenance.getLocation()==null){
            tmToolMaintenanceService.insertTmToolMaintenances(tmToolMaintenance);
        }
        startPage();
        List<TmToolMaintenance> list = tmToolMaintenanceService.selectTmToolMaintenanceList(tmToolMaintenance);
        return getDataTable(list);
    }


    /**
     * 获取要维护刀模版详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:maintenance:query')")
    @GetMapping(value = "/{toolMaintenanceId}")
    public AjaxResult getInfo(@PathVariable("toolMaintenanceId") Long toolMaintenanceId)
    {
        TmToolMaintenance tmToolMaintenance = tmToolMaintenanceService.selectTmToolMaintenanceByToolMaintenanceId(toolMaintenanceId);
        if(tmToolMaintenance.getStartTime()!=null){
        String startTime = tmToolMaintenance.getStartTime();
        // 设置要输出的时间格式（小写hh表示12小时制）
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date nowDate = DateUtils.getNowDate();
        String format = sdf.format(nowDate);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

            LocalDateTime startparse = LocalDateTime.parse(startTime, dateTimeFormatter);
            LocalDateTime endparse1 = LocalDateTime.parse(format, dateTimeFormatter);
            Duration between = Duration.between(startparse, endparse1);
            long hours = between.toHours();
            tmToolMaintenance.setProcessTime(hours);
            tmToolMaintenance.setEndTime(format);
        }

        return AjaxResult.success(tmToolMaintenance);
    }

    /**
     * 新增要维护刀模版
     */
    @PreAuthorize("@ss.hasPermi('md:maintenance:add')")
    @Log(title = "要维护刀模版", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TmToolMaintenance tmToolMaintenance)
    {
        return toAjax(tmToolMaintenanceService.insertTmToolMaintenance(tmToolMaintenance));
    }

    /**
     * 结束维护刀模版
     *
     * @param TmToolMaintenance 要维护刀模版
     * @return 结果
     */
    @PreAuthorize("@ss.hasPermi('md:maintenance:edit')")
    @Log(title = "要维护刀模版", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TmToolMaintenance TmToolMaintenance)
    {
        return toAjax(tmToolMaintenanceService.updateTmToolMaintenance(TmToolMaintenance));
    }

    /**
     * 删除要维护刀模版
     */
    @PreAuthorize("@ss.hasPermi('md:maintenance:edits')")
    @Log(title = "要维护刀模版", businessType = BusinessType.UPDATE)
    @PostMapping("/{toolMaintenanceId}")
    public AjaxResult startmaintenance(@PathVariable Long toolMaintenanceId)
    {

        return toAjax(tmToolMaintenanceService.deleteTmToolMaintenanceByToolMaintenanceIds(toolMaintenanceId));
    }


    /**
     * 删除台账维护
     */
    @PreAuthorize("@ss.hasPermi('tm:maintenance:remove')")
    @Log(title = "台账维护", businessType = BusinessType.DELETE)
    @DeleteMapping("/{toolMaintenanceId}")
    public AjaxResult remove(@PathVariable Long toolMaintenanceId)
    {
        return toAjax(tmToolMaintenanceService.deleteTmToolMainToolMainIds(toolMaintenanceId));
    }

}
