package com.ximai.mes.qc.service.impl;

import java.util.List;


import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.qc.mapper.QcAbnormalInformationMapper;
import com.ximai.mes.qc.domain.QcAbnormalInformation;
import com.ximai.mes.qc.service.IQcAbnormalInformationService;

/**
 * 异常信息Service业务层处理
 *
 * @author generator
 * @date 2024-02-19
 */
@Service
public class QcAbnormalInformationServiceImpl implements IQcAbnormalInformationService
{
    @Autowired
    private QcAbnormalInformationMapper qcAbnormalInformationMapper;

    /**
     * 查询异常信息
     *
     * @param abnormalId 异常信息主键
     * @return 异常信息
     */
    @Override
    public QcAbnormalInformation selectQcAbnormalInformationByAbnormalId(Long abnormalId)
    {
        return qcAbnormalInformationMapper.selectQcAbnormalInformationByAbnormalId(abnormalId);
    }

    /**
     * 查询异常信息列表
     *
     * @param qcAbnormalInformation 异常信息
     * @return 异常信息
     */
    @Override
    public List<QcAbnormalInformation> selectQcAbnormalInformationList(QcAbnormalInformation qcAbnormalInformation)
    {
        return qcAbnormalInformationMapper.selectQcAbnormalInformationList(qcAbnormalInformation);
    }

    /**
     * 新增异常信息
     *
     * @param qcAbnormalInformation 异常信息
     * @return 结果
     */
    @Override
    public int insertQcAbnormalInformation(QcAbnormalInformation qcAbnormalInformation)
    {


        qcAbnormalInformation.setCreateBy(SecurityUtils.getUsername());
        qcAbnormalInformation.setCreateTime(DateUtils.getNowDate());
        return qcAbnormalInformationMapper.insertQcAbnormalInformation(qcAbnormalInformation);
    }

    /**
     * 修改异常信息
     *
     * @param qcAbnormalInformation 异常信息
     * @return 结果
     */
    @Override
    public int updateQcAbnormalInformation(QcAbnormalInformation qcAbnormalInformation)
    {
        qcAbnormalInformation.setUpdateBy(SecurityUtils.getUsername());
        qcAbnormalInformation.setUpdateTime(DateUtils.getNowDate());
        return qcAbnormalInformationMapper.updateQcAbnormalInformation(qcAbnormalInformation);
    }

    /**
     * 批量删除异常信息
     *
     * @param abnormalIds 需要删除的异常信息主键
     * @return 结果
     */
    @Override
    public int deleteQcAbnormalInformationByAbnormalIds(Long[] abnormalIds)
    {
        return qcAbnormalInformationMapper.deleteQcAbnormalInformationByAbnormalIds(abnormalIds);
    }

    /**
     * 删除异常信息信息
     *
     * @param abnormalId 异常信息主键
     * @return 结果
     */
    @Override
    public int deleteQcAbnormalInformationByAbnormalId(Long abnormalId)
    {
        return qcAbnormalInformationMapper.deleteQcAbnormalInformationByAbnormalId(abnormalId);
    }
}
