package com.ximai.mes.pro.service.proWorkOrder;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderSoDirective;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;

/**
 * 生产工单指令Service接口
 *
 * @author zht
 * @date 2024-02-29
 */
public interface IProWorkOrderSoDirectiveService {
    /**
     * 查询生产工单指令
     *
     * @param workorderSoDirectiveId 生产工单指令主键
     * @return 生产工单指令
     */
    ProWorkOrderSoDirective selectProWorkOrderSoDirectiveByWorkorderSoDirectiveId(Long workorderSoDirectiveId);

    /**
     * 查询生产工单指令列表
     *
     * @param proWorkOrderSoDirective 生产工单指令
     * @return 生产工单指令集合
     */
    List<ProWorkOrderSoDirective> selectProWorkOrderSoDirectiveList(ProWorkOrderSoDirective proWorkOrderSoDirective);

    /**
     * 查询生产工单指令列表
     *
     * @param idList 生产工单指令
     * @return 生产工单指令集合
     */
    List<ProWorkOrderSoDirective> selectProWorkOrderSoDirectiveList(Collection<? extends Serializable> idList);

    /**
     * 查询生产工单指令列表
     *
     * @param idList 生产工单指令
     * @return 生产工单指令集合
     */
    List<ProWorkOrderSoDirective> selectProWorkOrderSoDirectiveList(QueryWrapper<ProWorkOrderSoDirective> qw);

    /**
     * 新增生产工单指令
     *
     * @param proWorkOrderSoDirective 生产工单指令
     * @return 结果
     */
    int insertProWorkOrderSoDirective(ProWorkOrderSoDirective proWorkOrderSoDirective);

    /**
     * 修改生产工单指令
     *
     * @param proWorkOrderSoDirective 生产工单指令
     * @return 结果
     */
    int updateProWorkOrderSoDirective(ProWorkOrderSoDirective proWorkOrderSoDirective);

    /**
     * 批量删除生产工单指令
     *
     * @param workorderSoDirectiveIds 需要删除的生产工单指令主键集合
     * @return 结果
     */
    int deleteProWorkOrderSoDirectiveByWorkorderSoDirectiveIds(Long[] workorderSoDirectiveIds);

    /**
     * 删除生产工单指令信息
     *
     * @param workorderSoDirectiveId 生产工单指令主键
     * @return 结果
     */
    int deleteProWorkOrderSoDirectiveByWorkorderSoDirectiveId(Long workorderSoDirectiveId);

    void deleteByWorkorderCode(String workorderCode);
}
