package com.ximai.mes.pro.service.proWorkOrder;

import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderProcessTool;

import java.util.List;
import java.util.Map;

/**
 * 工单工序质检项Service接口
 *
 * @author zht
 * @date 2024-01-28
 */
public interface IProWorkOrderProcessToolService {


    /**
     * 查询工单工序质检项
     *
     * @param workorderProcessToolId 工单工序质检项主键
     * @return 工单工序质检项
     */
    ProWorkOrderProcessTool selectProWorkOrderProcessToolByWorkorderProcessToolId(Long workorderProcessToolId);

    /**
     * 查询工单工序质检项列表
     *
     * @param proWorkOrderProcessTool 工单工序质检项
     * @return 工单工序质检项集合
     */
    List<ProWorkOrderProcessTool> selectProWorkOrderProcessToolList(ProWorkOrderProcessTool proWorkOrderProcessTool);

    /**
     * 新增工单工序质检项
     *
     * @param proWorkOrderProcessTool 工单工序质检项
     * @return 结果
     */
    int insertProWorkOrderProcessTool(ProWorkOrderProcessTool proWorkOrderProcessTool);

    /**
     * 修改工单工序质检项
     *
     * @param proWorkOrderProcessTool 工单工序质检项
     * @return 结果
     */
    int updateProWorkOrderProcessTool(ProWorkOrderProcessTool proWorkOrderProcessTool);

    /**
     * 批量删除工单工序质检项
     *
     * @param workorderProcessToolIds 需要删除的工单工序质检项主键集合
     * @return 结果
     */
    int deleteProWorkOrderProcessToolByWorkorderProcessToolIds(Long[] workorderProcessToolIds);

    /**
     * 删除工单工序质检项信息
     *
     * @param workorderProcessToolId 工单工序质检项主键
     * @return 结果
     */
    int deleteProWorkOrderProcessToolByWorkorderProcessToolId(Long workorderProcessToolId);

    void deleteByWorkorderCode(String workorderCode);


    boolean checkProcessToolIsExsit(Long taskWorkunitId);

    Map<Long, Integer> selectRequiredToolForWorkunitTask(Long taskWorkunitId);

}
