package com.ximai.mes.pro.service.impl.productionSolution;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.productionSolution.ProProductionSolutionBomMapper;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionBom;
import com.ximai.mes.pro.service.productionSolution.IProProductionSolutionBomService;

/**
 * 生产版本BOMService业务层处理
 *
 * @author zht
 * @date 2024-01-23
 */
@Service
public class ProProductionSolutionBomServiceImpl implements IProProductionSolutionBomService
{
    @Autowired
    private ProProductionSolutionBomMapper proProductionSolutionBomMapper;

    /**
     * 查询生产版本BOM
     *
     * @param bomItemId 生产版本BOM主键
     * @return 生产版本BOM
     */
    @Override
    public ProProductionSolutionBom selectProProductionSolutionBomByBomItemId(Long bomItemId)
    {
        return proProductionSolutionBomMapper.selectProProductionSolutionBomByBomItemId(bomItemId);
    }

    /**
     * 查询生产版本BOM列表
     *
     * @param proProductionSolutionBom 生产版本BOM
     * @return 生产版本BOM
     */
    @Override
    public List<ProProductionSolutionBom> selectProProductionSolutionBomList(ProProductionSolutionBom proProductionSolutionBom)
    {
        return proProductionSolutionBomMapper.selectProProductionSolutionBomList(proProductionSolutionBom);
    }

    /**
     * 新增生产版本BOM
     *
     * @param proProductionSolutionBom 生产版本BOM
     * @return 结果
     */
    @Override
    public int insertProProductionSolutionBom(ProProductionSolutionBom proProductionSolutionBom)
    {
        return proProductionSolutionBomMapper.insertProProductionSolutionBom(proProductionSolutionBom);
    }

    /**
     * 修改生产版本BOM
     *
     * @param proProductionSolutionBom 生产版本BOM
     * @return 结果
     */
    @Override
    public int updateProProductionSolutionBom(ProProductionSolutionBom proProductionSolutionBom)
    {
        return proProductionSolutionBomMapper.updateProProductionSolutionBom(proProductionSolutionBom);
    }

    /**
     * 批量删除生产版本BOM
     *
     * @param bomItemIds 需要删除的生产版本BOM主键
     * @return 结果
     */
    @Override
    public int deleteProProductionSolutionBomByBomItemIds(Long[] bomItemIds)
    {
        return proProductionSolutionBomMapper.deleteProProductionSolutionBomByBomItemIds(bomItemIds);
    }

    /**
     * 删除生产版本BOM信息
     *
     * @param bomItemId 生产版本BOM主键
     * @return 结果
     */
    @Override
    public int deleteProProductionSolutionBomByBomItemId(Long bomItemId)
    {
        return proProductionSolutionBomMapper.deleteProProductionSolutionBomByBomItemId(bomItemId);
    }
}
