package com.ximai.mes.pro.domain.vo;

import com.ximai.common.annotation.Excel;
import com.ximai.mes.pro.domain.productionRequest.ProProductionRequestBom;
import lombok.Data;

import java.util.List;

@Data
public class ProProductionRequestVo
{
    private static final long serialVersionUID = 1L;

    /** 样品申请单ID */
    private Long productionRequestId;

    /** 样品申请单编码 */
    private String productionRequestCode;

    /** 产品ID */
    private Long itemId;

    private String itemName;

    /** 工艺路线ID */
    private Long routeId;

    private String routeName;

    /** 制造工厂ID */
    @Excel(name = "制造工厂ID")
    private Long factoryId;

    private String factoryName;

    /** 仓库 */
    @Excel(name = "仓库")
    private String warehouse;

    /** 尺码组 */
    @Excel(name = "尺码组")
    private String sizeGroup;

    /** 是否要鞋图 */
    @Excel(name = "是否要鞋图")
    private Integer isNeedShoeImg;

    /** 是否附样品 */
    @Excel(name = "是否附样品")
    private Integer isNeedPrototype;

    /** 唯一码产品 */
    @Excel(name = "唯一码产品")
    private Integer isUniqueCode;

    /** 不考虑型体配色 */
    @Excel(name = "不考虑型体配色")
    private Integer isConsiderColor;

    /** 是否禁用 */
    @Excel(name = "是否禁用")
    private Integer isDisabled;

    /** 鞋图 */
    @Excel(name = "鞋图")
    private String shoeImg;

    /** 样品 */
    @Excel(name = "样品")
    private String prototype;

    /** 申请单状态 */
    private String productionRequestStatus;

    /** 测试标准 */
    private String testStandard;

    private String remark;

    /** Bom列表 */
    private List<ProProductionRequestBom> bomList;

    /** 工序列表 */
    private List<ProProductionRequestProcessVo> processList;

}
