package com.ximai.mes.pro.domain.proWorkOrder;

import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * 生产工单指令对象 pro_work_order_so_directive
 *
 * @author zht
 * @date 2024-02-29
 */
@ApiOperation("生产工单指令")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ProWorkOrderSoDirective extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @TableId
    private Long workorderSoDirectiveId;

    /**
     * 工单ID
     */
    @Excel(name = "工单ID")
    @ApiModelProperty("工单ID")
    private Long workorderId;


    /**
     * 工单ID
     */
    @Excel(name = "工单ID")
    @ApiModelProperty("工单ID")
    private String workorderCode;

    /**
     * 指令号
     */
    @Excel(name = "指令号")
    @ApiModelProperty("指令号")
    private String clientCmd;

    /**
     * 派工数
     */
    @Excel(name = "派工数")
    @ApiModelProperty("派工数")
    private BigDecimal dispatchMultiple;

    /**
     * 数量
     */
    @Excel(name = "数量")
    @ApiModelProperty("数量")
    private BigDecimal quantity;

    /**
     * LOSS数
     */
    @Excel(name = "LOSS数")
    @ApiModelProperty("LOSS数")
    private BigDecimal lossNum;

    /**
     * 销售凭证
     */
    @Excel(name = "销售凭证")
    @ApiModelProperty("销售凭证")
    private String salesVoucher;

    /**
     * 销售凭证项目
     */
    @Excel(name = "销售凭证项目")
    @ApiModelProperty("销售凭证项目")
    private String salesVoucherItem;

    /**
     * 客户编号
     */
    @Excel(name = "客户编号")
    @ApiModelProperty("客户编号")
    private String clientCode;


    /**
     * 客户编号
     */
    @Excel(name = "客户名称")
    @ApiModelProperty("客户名称")
    private String clientName;

    /**
     * 尺码组
     */
    @Excel(name = "尺码组")
    @ApiModelProperty("尺码组")
    private String sizeGroup;

    /**
     * 尺码单位（客户）
     */
    @Excel(name = "尺码单位", readConverterExp = "客=户")
    @ApiModelProperty("尺码单位")
    private String clientSizeUnit;

    /**
     * 型体号
     */
    @Excel(name = "型体号")
    @ApiModelProperty("型体号")
    private String typeNo;

    /**
     * 配色号
     */
    @Excel(name = "配色号")
    @ApiModelProperty("配色号")
    private String colorNo;

    /**
     * 颜色
     */
    @Excel(name = "颜色")
    @ApiModelProperty("颜色")
    private String color;

    /**
     * 销线
     */
    @Excel(name = "销线")
    @ApiModelProperty("销线")
    private String salePath;

    /**
     * 段别
     */
    @Excel(name = "段别")
    @ApiModelProperty("段别")
    private String segment;

    /**
     * 季度
     */
    @Excel(name = "季度")
    @ApiModelProperty("季度")
    private String quarter;

    /**
     * 整/半码
     */
    @Excel(name = "整/半码")
    @ApiModelProperty("整/半码")
    private String wholeSize;

    /**
     * 特殊SIZE
     */
    @Excel(name = "特殊SIZE")
    @ApiModelProperty("特殊SIZE")
    private String specSize;

    /**
     * PO#
     */
    @Excel(name = "PO#")
    @ApiModelProperty("PO#")
    private String poNo;

    /**
     * WIP#
     */
    @Excel(name = "WIP#")
    @ApiModelProperty("WIP#")
    private String wipNo;

    /**
     * 装箱数
     */
    @Excel(name = "装箱数")
    @ApiModelProperty("装箱数")
    private String packingNum;

    /**
     * 产地
     */
    @Excel(name = "产地")
    @ApiModelProperty("产地")
    private String region;

    /**
     * 周期
     */
    @Excel(name = "周期")
    @ApiModelProperty("周期")
    private String cycle;

    /**
     * SK编号
     */
    @Excel(name = "SK编号")
    @ApiModelProperty("SK编号")
    private String skNo;

    /**
     * 专利号
     */
    @Excel(name = "专利号")
    @ApiModelProperty("专利号")
    private String patentNo;

    /**
     * 材质描述
     */
    @Excel(name = "材质描述")
    @ApiModelProperty("材质描述")
    private String materialDesc;

    /**
     * 签收人
     */
    @Excel(name = "签收人")
    @ApiModelProperty("签收人")
    private String signer;

    /**
     * SHIP TO ID
     */
    @Excel(name = "SHIP TO ID")
    @ApiModelProperty("SHIP TO ID")
    private String shipToId;

    /**
     * 产品规格
     */
    @Excel(name = "产品规格")
    @ApiModelProperty("产品规格")
    private String prodSpec;

    /**
     * 产品用途
     */
    @Excel(name = "产品用途")
    @ApiModelProperty("产品用途")
    private String prodUsage;

    /**
     * 厚度（丝）
     */
    @Excel(name = "厚度", readConverterExp = "丝=")
    @ApiModelProperty("厚度")
    private String thickness;

    /**
     * 包装方式
     */
    @Excel(name = "包装方式")
    @ApiModelProperty("包装方式")
    private String packMode;

    /**
     * 印刷方向
     */
    @Excel(name = "印刷方向")
    @ApiModelProperty("印刷方向")
    private String printingDirection;

    /**
     * 工厂代号
     */
    @Excel(name = "工厂代号")
    @ApiModelProperty("工厂代号")
    private String plantCode;

    /**
     * 采购组织
     */
    @Excel(name = "采购组织")
    @ApiModelProperty("采购组织")
    private String purchaseOrg;

    /**
     * 已生产数量
     */
    @ApiModelProperty("已生产数量")
    private BigDecimal quantityProduced;

    /**
     * 合格品数量
     */
    @ApiModelProperty("合格品数量")
    private BigDecimal quantityQualify;

    /**
     * 不良品数量
     */
    @ApiModelProperty("不良品数量")
    private BigDecimal quantityUnqualify;


    /**
     * 包装数量
     */
    @ApiModelProperty("包装数量")
    private BigDecimal packNum;

    /**
     * 包装类型
     */
    @ApiModelProperty("包装类型")
    private String packType;

    /**
     * 包装单位
     */
    @ApiModelProperty("包装单位")
    private String packUnit;

    /**
     * LOSS
     */
    @ApiModelProperty("LOSS数量是否单独包装")
    private String lossPack;


}
