package com.ximai.mes.pro.controller.task;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.domain.model.LoginUser;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.SecurityUtils;
import com.ximai.common.utils.data.ExceptionUtil;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkorder;
import com.ximai.mes.pro.domain.task.ProTaskWorkunit;
import com.ximai.mes.pro.domain.vo.ProTaskVo;
import com.ximai.mes.pro.domain.vo.task.ProTaskWorkunitQuery;
import com.ximai.mes.pro.domain.vo.task.TaskWorkunitOutsourceSplitParam;
import com.ximai.mes.pro.domain.vo.task.TaskWorkunitToOutsourceParam;
import com.ximai.mes.pro.domain.vo.task.TaskWorkunitToSelfMadeParam;
import com.ximai.mes.pro.service.task.IProTaskWorkunitService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

/**
 * 任务工作单元Controller
 *
 * @author zht
 * @date 2024-01-23
 */
@RestController
@RequestMapping("/mes/pro/taskWorkunit")
public class ProTaskWorkunitController extends BaseController {
    @Autowired
    private IProTaskWorkunitService proTaskWorkunitService;

    /**
     * 查询任务工作单元列表
     */
    @ApiOperation("查询任务工作单元列表")
    @PreAuthorize("@ss.hasPermi('mes:pro:taskWorkunit:list')")
    @PostMapping("/list")
    public TableDataInfo<ProTaskWorkunit> list(@RequestBody ProTaskWorkunitQuery proTaskWorkunit) {
        startPage();
        List<ProTaskWorkunit> lists = proTaskWorkunitService.schedulingList(proTaskWorkunit);
        return getDataTable(lists);
    }

    @ApiOperation("查询任务工作单元列表")
    @PostMapping("/workorderList")
    public List<ProWorkorder> listWorkorder(@RequestBody ProTaskWorkunitQuery proTaskWorkunit) {
        return proTaskWorkunitService.selectWorkorderTaskByQw(proTaskWorkunit);
    }

    /**
     * 获取任务工作单元详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:taskWorkunit:query')")
    @GetMapping(value = "/{taskWorkunitId}")
    public AjaxResult getInfo(@PathVariable("taskWorkunitId") Long taskWorkunitId) {
        return AjaxResult.success(proTaskWorkunitService.selectProTaskWorkunitByTaskWorkunitId(taskWorkunitId));
    }

    /**
     * 新增任务工作单元
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:taskWorkunit:add')")
    @Log(title = "任务工作单元", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProTaskWorkunit proTaskWorkunit) {
        return toAjax(proTaskWorkunitService.insertProTaskWorkunit(proTaskWorkunit));
    }

    /**
     * 修改任务工作单元
     */
    @ApiOperation("修改生产任务数据")
    @PreAuthorize("@ss.hasPermi('mes:pro:taskWorkunit:edit')")
    @Log(title = "修改生产任务数据", businessType = BusinessType.UPDATE)
    @PostMapping("/update")
    public AjaxResult edit(@RequestBody ProTaskWorkunit proTaskWorkunit) {
        return toAjax(proTaskWorkunitService.updateProTaskWorkunit(proTaskWorkunit));
    }

    /**
     * 修改任务工作单元排产时间、工作单元
     */
    @ApiOperation("修改生产任务数据")
    @PreAuthorize("@ss.hasPermi('mes:pro:taskWorkunit:edit')")
    @Log(title = "修改生产任务数据", businessType = BusinessType.UPDATE)
    @PostMapping("/updateTimeAndWorkunit")
    public AjaxResult updateTimeAndWorkunit(@RequestBody ProTaskWorkunit proTaskWorkunit) {
        proTaskWorkunitService.updateProTaskWorkunitTimeAndWorkunit(proTaskWorkunit);
        return AjaxResult.success();
    }

    /**
     * 删除任务工作单元
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:taskWorkunit:remove')")
    @Log(title = "任务工作单元", businessType = BusinessType.DELETE)
    @DeleteMapping("/{taskWorkunitIds}")
    public AjaxResult remove(@PathVariable Long[] taskWorkunitIds) {
        return toAjax(proTaskWorkunitService.deleteProTaskWorkunitByTaskWorkunitIds(taskWorkunitIds));
    }

    @ApiOperation("下达生产")
    @Log(title = "下达生产", businessType = BusinessType.OTHER)
    @PostMapping("/makeProduction")
    public AjaxResult makeProduction(@ApiParam(value = "派工任务ID", required = true) @RequestParam Long[] taskWorkunitIds) {
        proTaskWorkunitService.makeProduction(taskWorkunitIds);
        return AjaxResult.success();
    }
    @ApiOperation("转外委")
    @Log(title = "转外委", businessType = BusinessType.UPDATE)
    @PostMapping(value = "/toOutsource")
    public AjaxResult toOutsource(@RequestBody List<TaskWorkunitToOutsourceParam> taskWorkunitToOutsourceParam) {
        proTaskWorkunitService.toOutsource(taskWorkunitToOutsourceParam);
        return AjaxResult.success();
    }
    @ApiOperation("转自制")
    @Log(title = "转自制", businessType = BusinessType.UPDATE)
    @PostMapping(value = "/toSelfMade")
    public AjaxResult toSelfMade(@RequestBody List<TaskWorkunitToSelfMadeParam> taskWorkunitToSelfMadeParam) {
        proTaskWorkunitService.toSelfMade(taskWorkunitToSelfMadeParam);
        return AjaxResult.success();
    }
    @ApiOperation("外委拆分")
    @Log(title = "外委拆分", businessType = BusinessType.UPDATE)
    @PostMapping(value = "/outsourceSplit")
    public AjaxResult outsourceSplit(@RequestBody List<TaskWorkunitOutsourceSplitParam>  taskWorkunitOutsourceSplitParam) {
        proTaskWorkunitService.outsourceSplit(taskWorkunitOutsourceSplitParam);
        return AjaxResult.success();
    }

    @ApiOperation("外委确认")
    @Log(title = "外委确认", businessType = BusinessType.UPDATE)
    @PostMapping(value = "/outsourceConfirm")
    public AjaxResult outsourceConfirm(@RequestBody List<Long>  taskWorkunitIds) {
        proTaskWorkunitService.outsourceConfirm(taskWorkunitIds);
        return AjaxResult.success();
    }



    @ApiOperation("获取工序打印日记")
    @Log(title = "获取工序打印日记", businessType = BusinessType.UPDATE)
    @PostMapping(value= "/printData")
    public AjaxResult printData(@RequestBody List<Long>  taskIds) {
        Map<String,Object> printData =  proTaskWorkunitService.printData(taskIds);
        return AjaxResult.success("获取成功",printData);
    }

}
