package com.ximai.mes.pro.controller.productionSolution;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionProcessItem;
import com.ximai.mes.pro.service.productionSolution.IProProductionSolutionProcessItemService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 生产版本工序物料Controller
 *
 * @author zht
 * @date 2024-01-23
 */
@RestController
@RequestMapping("/mes/pro/productionSolutionProcessItem")
public class ProProductionSolutionProcessItemController extends BaseController
{
    @Autowired
    private IProProductionSolutionProcessItemService proProductionSolutionProcessItemService;

    /**
     * 查询生产版本工序物料列表
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionSolutionProcessItem:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProProductionSolutionProcessItem proProductionSolutionProcessItem)
    {
        startPage();
        List<ProProductionSolutionProcessItem> list = proProductionSolutionProcessItemService.selectProProductionSolutionProcessItemList(proProductionSolutionProcessItem);
        return getDataTable(list);
    }

    /**
     * 获取生产版本工序物料详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionSolutionProcessItem:query')")
    @GetMapping(value = "/{productionSolutionProcessItemId}")
    public AjaxResult getInfo(@PathVariable("productionSolutionProcessItemId") Long productionSolutionProcessItemId)
    {
        return AjaxResult.success(proProductionSolutionProcessItemService.selectProProductionSolutionProcessItemByProductionSolutionProcessItemId(productionSolutionProcessItemId));
    }

    /**
     * 新增生产版本工序物料
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionSolutionProcessItem:add')")
    @Log(title = "生产版本工序物料", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProProductionSolutionProcessItem proProductionSolutionProcessItem)
    {
        return toAjax(proProductionSolutionProcessItemService.insertProProductionSolutionProcessItem(proProductionSolutionProcessItem));
    }

    /**
     * 修改生产版本工序物料
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionSolutionProcessItem:edit')")
    @Log(title = "生产版本工序物料", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProProductionSolutionProcessItem proProductionSolutionProcessItem)
    {
        return toAjax(proProductionSolutionProcessItemService.updateProProductionSolutionProcessItem(proProductionSolutionProcessItem));
    }

    /**
     * 删除生产版本工序物料
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionSolutionProcessItem:remove')")
    @Log(title = "生产版本工序物料", businessType = BusinessType.DELETE)
	@DeleteMapping("/{productionSolutionProcessItemIds}")
    public AjaxResult remove(@PathVariable Long[] productionSolutionProcessItemIds)
    {
        return toAjax(proProductionSolutionProcessItemService.deleteProProductionSolutionProcessItemByProductionSolutionProcessItemIds(productionSolutionProcessItemIds));
    }
}
