package com.ximai.mes.md.service.impl;

import java.util.List;
import com.ximai.common.utils.data.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.md.mapper.MdProductPublishedConfMapper;
import com.ximai.mes.md.domain.MdProductPublishedConf;
import com.ximai.mes.md.service.IMdProductPublishedConfService;

/**
 * 产品打样排版参数配置Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-17
 */
@Service
public class MdProductPublishedConfServiceImpl implements IMdProductPublishedConfService
{
    @Autowired
    private MdProductPublishedConfMapper mdProductPublishedConfMapper;

    /**
     * 查询产品打样排版参数配置
     *
     * @param itemId 产品打样排版参数配置主键
     * @return 产品打样排版参数配置
     */
    @Override
    public MdProductPublishedConf selectMdProductPublishedConfByItemId(Long itemId)
    {
        return mdProductPublishedConfMapper.selectMdProductPublishedConfByItemId(itemId);
    }

    /**
     * 查询产品打样排版参数配置列表
     *
     * @param mdProductPublishedConf 产品打样排版参数配置
     * @return 产品打样排版参数配置
     */
    @Override
    public List<MdProductPublishedConf> selectMdProductPublishedConfList(MdProductPublishedConf mdProductPublishedConf)
    {
        return mdProductPublishedConfMapper.selectMdProductPublishedConfList(mdProductPublishedConf);
    }

    /**
     * 新增产品打样排版参数配置
     *
     * @param mdProductPublishedConf 产品打样排版参数配置
     * @return 结果
     */
    @Override
    public int insertMdProductPublishedConf(MdProductPublishedConf mdProductPublishedConf)
    {
        mdProductPublishedConf.setCreateTime(DateUtils.getNowDate());
        return mdProductPublishedConfMapper.insertMdProductPublishedConf(mdProductPublishedConf);
    }

    /**
     * 修改产品打样排版参数配置
     *
     * @param mdProductPublishedConf 产品打样排版参数配置
     * @return 结果
     */
    @Override
    public int updateMdProductPublishedConf(MdProductPublishedConf mdProductPublishedConf)
    {
        mdProductPublishedConf.setUpdateTime(DateUtils.getNowDate());
        return mdProductPublishedConfMapper.updateMdProductPublishedConf(mdProductPublishedConf);
    }

    /**
     * 批量删除产品打样排版参数配置
     *
     * @param itemIds 需要删除的产品打样排版参数配置主键
     * @return 结果
     */
    @Override
    public int deleteMdProductPublishedConfByItemIds(Long[] itemIds)
    {
        return mdProductPublishedConfMapper.deleteMdProductPublishedConfByItemIds(itemIds);
    }

    /**
     * 删除产品打样排版参数配置信息
     *
     * @param itemId 产品打样排版参数配置主键
     * @return 结果
     */
    @Override
    public int deleteMdProductPublishedConfByItemId(Long itemId)
    {
        return mdProductPublishedConfMapper.deleteMdProductPublishedConfByItemId(itemId);
    }
}
