package com.ximai.mes.md.mapper;

import com.ximai.mes.md.domain.MdSapDict;

import java.util.List;

/**
 * sap特性字典Mapper接口
 *
 * @author yinjinlu
 * @date 2024-01-16
 */
public interface MdSapDictMapper {
    /**
     * 查询sap特性字典
     *
     * @param id sap特性字典主键
     * @return sap特性字典
     */
    MdSapDict selectSapDictById(String id);

    /**
     * 查询sap特性字典列表
     *
     * @param mdSapDict sap特性字典
     * @return sap特性字典集合
     */
    List<MdSapDict> selectSapDictList(MdSapDict mdSapDict);

    /**
     * 新增sap特性字典
     *
     * @param mdSapDict sap特性字典
     * @return 结果
     */
    int insertSapDict(MdSapDict mdSapDict);

    /**
     * 修改sap特性字典
     *
     * @param mdSapDict sap特性字典
     * @return 结果
     */
    int updateSapDict(MdSapDict mdSapDict);

    /**
     * 删除sap特性字典
     *
     * @param id sap特性字典主键
     * @return 结果
     */
    int deleteSapDictById(String id);

    /**
     * 批量删除sap特性字典
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    int deleteSapDictByIds(String[] ids);
}
