package com.ximai.mes.dv.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.dv.domain.devBrandQuotation.DevBrandQuotationProcessTool;
import com.ximai.mes.dv.service.devBrandQuotation.IDevBrandQuotationProcessToolService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 品牌报价工序工装夹具Controller
 *
 * @author generator
 * @date 2024-01-28
 */
@RestController
@RequestMapping("/dv/brandQuotationProcessTool")
public class DevBrandQuotationProcessToolController extends BaseController
{
    @Autowired
    private IDevBrandQuotationProcessToolService devBrandQuotationProcessToolService;

    /**
     * 查询品牌报价工序工装夹具列表
     */
    @PreAuthorize("@ss.hasPermi('dv:brandQuotationProcessTool:list')")
    @GetMapping("/list")
    public TableDataInfo list(DevBrandQuotationProcessTool devBrandQuotationProcessTool)
    {
        startPage();
        List<DevBrandQuotationProcessTool> list = devBrandQuotationProcessToolService.selectDevBrandQuotationProcessToolList(devBrandQuotationProcessTool);
        return getDataTable(list);
    }

    /**
     * 获取品牌报价工序工装夹具详细信息
     */
    @PreAuthorize("@ss.hasPermi('dv:brandQuotationProcessTool:query')")
    @GetMapping(value = "/{brandQuotationProcessToolId}")
    public AjaxResult getInfo(@PathVariable("brandQuotationProcessToolId") Long brandQuotationProcessToolId)
    {
        return AjaxResult.success(devBrandQuotationProcessToolService.selectDevBrandQuotationProcessToolByBrandQuotationProcessToolId(brandQuotationProcessToolId));
    }

    /**
     * 新增品牌报价工序工装夹具
     */
    @PreAuthorize("@ss.hasPermi('dv:brandQuotationProcessTool:add')")
    @Log(title = "品牌报价工序工装夹具", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody DevBrandQuotationProcessTool devBrandQuotationProcessTool)
    {
        return toAjax(devBrandQuotationProcessToolService.insertDevBrandQuotationProcessTool(devBrandQuotationProcessTool));
    }

    /**
     * 修改品牌报价工序工装夹具
     */
    @PreAuthorize("@ss.hasPermi('dv:brandQuotationProcessTool:edit')")
    @Log(title = "品牌报价工序工装夹具", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody DevBrandQuotationProcessTool devBrandQuotationProcessTool)
    {
        return toAjax(devBrandQuotationProcessToolService.updateDevBrandQuotationProcessTool(devBrandQuotationProcessTool));
    }

    /**
     * 删除品牌报价工序工装夹具
     */
    @PreAuthorize("@ss.hasPermi('dv:brandQuotationProcessTool:remove')")
    @Log(title = "品牌报价工序工装夹具", businessType = BusinessType.DELETE)
	@DeleteMapping("/{brandQuotationProcessToolIds}")
    public AjaxResult remove(@PathVariable Long[] brandQuotationProcessToolIds)
    {
        return toAjax(devBrandQuotationProcessToolService.deleteDevBrandQuotationProcessToolByBrandQuotationProcessToolIds(brandQuotationProcessToolIds));
    }
}
