import request from "@/utils/request";

// 查询生产版本工序物料列表
export function listProductionSolutionProcessItem(query) {
  return request({
    url: "/mes/pro/productionSolutionProcessItem/list",
    method: "get",
    params: query,
  });
}

// 查询生产版本工序物料详细
export function getProductionSolutionProcessItem(
  productionSolutionProcessItemId
) {
  return request({
    url:
      "/mes/pro/productionSolutionProcessItem/" +
      productionSolutionProcessItemId,
    method: "get",
  });
}

// 新增生产版本工序物料
export function addProductionSolutionProcessItem(data) {
  return request({
    url: "/mes/pro/productionSolutionProcessItem",
    method: "post",
    data: data,
  });
}

// 修改生产版本工序物料
export function updateProductionSolutionProcessItem(data) {
  return request({
    url: "/mes/pro/productionSolutionProcessItem",
    method: "put",
    data: data,
  });
}

// 删除生产版本工序物料
export function delProductionSolutionProcessItem(
  productionSolutionProcessItemId
) {
  return request({
    url:
      "/mes/pro/productionSolutionProcessItem/" +
      productionSolutionProcessItemId,
    method: "delete",
  });
}
