import request from '@/utils/request'

// 查询量产制作BOM列表
export function listProductionMakeBom(query) {
  return request({
    url: '/md/productionMakeBom/list',
    method: 'get',
    params: query
  })
}

// 查询量产制作BOM详细
export function getProductionMakeBom(bomItemId) {
  return request({
    url: '/md/productionMakeBom/' + bomItemId,
    method: 'get'
  })
}

// 新增量产制作BOM
export function addProductionMakeBom(data) {
  return request({
    url: '/md/productionMakeBom',
    method: 'post',
    data: data
  })
}

// 修改量产制作BOM
export function updateProductionMakeBom(data) {
  return request({
    url: '/md/productionMakeBom',
    method: 'put',
    data: data
  })
}

// 删除量产制作BOM
export function delProductionMakeBom(bomItemId) {
  return request({
    url: '/md/productionMakeBom/' + bomItemId,
    method: 'delete'
  })
}
