import request from '@/utils/request'

// 查询打印模板配置列表
export function listPrintTemplate(query) {
  return request({
    url: '/system/printTemplate/list',
    method: 'get',
    params: query
  })
}

// 查询打印模板配置详细
export function getPrintTemplate(templateId) {
  return request({
    url: '/system/printTemplate/' + templateId,
    method: 'get'
  })
}

// 新增打印模板配置
export function addPrintTemplate(data) {
  return request({
    url: '/system/printTemplate',
    method: 'post',
    data: data
  })
}

// 修改打印模板配置
export function updatePrintTemplate(data) {
  return request({
    url: '/system/printTemplate',
    method: 'put',
    data: data
  })
}

// 删除打印模板配置
export function delPrintTemplate(templateId) {
  return request({
    url: '/system/printTemplate/' + templateId,
    method: 'delete'
  })
}
