import request from "@/utils/request";

// 查询量产申请列表
export function listProductionRequest(query) {
  return request({
    url: "/mes/pro/productionRequest/list",
    method: "get",
    params: query,
  });
}

// 查询量产申请详细
export function getProductionRequest(productionRequestId) {
  return request({
    url: "/mes/pro/productionRequest/" + productionRequestId,
    method: "get",
  });
}

// 新增量产申请
export function addProductionRequest(data) {
  return request({
    url: "/mes/pro/productionRequest",
    method: "post",
    data: data,
  });
}

// 修改量产申请
export function updateProductionRequest(data) {
  return request({
    url: "/mes/pro/productionRequest",
    method: "put",
    data: data,
  });
}

// 删除量产申请
export function delProductionRequest(productionRequestId) {
  return request({
    url: "/mes/pro/productionRequest/" + productionRequestId,
    method: "delete",
  });
}

// 修改状态
export function dofinish(data) {
  return request({
    url: "/mes/pro/productionRequest/modifyState",
    method: "put",
    data: data,
  });
}
