import request from '@/utils/request'

// 查询产品特性名称列表
export function listSpec(query) {
  return request({
    url: '/md/spec/list',
    method: 'get',
    params: query
  })
}

// 查询产品特性名称详细
export function getSpec(itemSpecId) {
  return request({
    url: '/md/spec/' + itemSpecId,
    method: 'get'
  })
}

// 新增产品特性名称
export function addSpec(data) {
  return request({
    url: '/md/spec',
    method: 'post',
    data: data
  })
}

// 修改产品特性名称
export function updateSpec(data) {
  return request({
    url: '/md/spec',
    method: 'put',
    data: data
  })
}

// 删除产品特性名称
export function delSpec(itemSpecId) {
  return request({
    url: '/md/spec/' + itemSpecId,
    method: 'delete'
  })
}
