import request from '@/utils/request'

// 查询尺码组列表
export function listGroup(query) {
  return request({
    url: '/md/group/list',
    method: 'get',
    params: query
  })
}

// 查询尺码组详细
export function getGroup(sizeGroupId) {
  return request({
    url: '/md/group/' + sizeGroupId,
    method: 'get'
  })
}

// 新增尺码组
export function addGroup(data) {
  return request({
    url: '/md/group',
    method: 'post',
    data: data
  })
}

// 修改尺码组
export function updateGroup(data) {
  return request({
    url: '/md/group',
    method: 'put',
    data: data
  })
}

// 删除尺码组
export function delGroup(sizeGroupId) {
  return request({
    url: '/md/group/' + sizeGroupId,
    method: 'delete'
  })
}
