import request from '@/utils/request'

// 查询销售订单销售小组列表
export function listGroup(query) {
  return request({
    url: '/md/ordergroup/list',
    method: 'get',
    params: query
  })
}

// 查询销售订单销售小组详细
export function getGroup(id) {
  return request({
    url: '/md/ordergroup/' + id,
    method: 'get'
  })
}

// 新增销售订单销售小组
export function addGroup(data) {
  return request({
    url: '/md/ordergroup',
    method: 'post',
    data: data
  })
}

// 修改销售订单销售小组
export function updateGroup(data) {
  return request({
    url: '/md/ordergroup',
    method: 'put',
    data: data
  })
}

// 删除销售订单销售小组
export function delGroup(id) {
  return request({
    url: '/md/ordergroup/' + id,
    method: 'delete'
  })
}
