import request from '@/utils/request'

// 查询列表
export function listPropertytype(query) {
  return request({
    url: '/md/propertytype/list',
    method: 'get',
    params: query
  })
}

// 查询详细
export function getPropertytype(clientId) {
  return request({
    url: '/md/propertytype/' + clientId,
    method: 'get'
  })
}

// 新增
export function addPropertytype(data) {
  return request({
    url: '/md/propertytype',
    method: 'post',
    data: data
  })
}

// 修改
export function updatePropertytype(data) {
  return request({
    url: '/md/propertytype',
    method: 'put',
    data: data
  })
}

// 删除
export function delPropertytype(clientId) {
  return request({
    url: '/md/propertytype/' + clientId,
    method: 'delete'
  })
}
