import request from '@/utils/request'

// 查询产品loss配置列表
export function listLoss(query) {
  return request({
    url: '/md/loss/list',
    method: 'get',
    params: query
  })
}

// 查询产品loss配置详细
export function getLoss(productLossId) {
  return request({
    url: '/md/loss/' + productLossId,
    method: 'get'
  })
}

// 新增产品loss配置
export function addLoss(data) {
  return request({
    url: '/md/loss',
    method: 'post',
    data: data
  })
}

// 修改产品loss配置
export function updateLoss(data) {
  return request({
    url: '/md/loss',
    method: 'put',
    data: data
  })
}

// 删除产品loss配置
export function delLoss(productLossId) {
  return request({
    url: '/md/loss/' + productLossId,
    method: 'delete'
  })
}
