import request from '@/utils/request'

// 查询产品外观列表
export function listLook(query) {
  return request({
    url: '/md/look/list',
    method: 'get',
    params: query
  })
}

// 查询产品外观详细
export function getLook(itemId) {
  return request({
    url: '/md/look/' + itemId,
    method: 'get'
  })
}

// 新增产品外观
export function addLook(data) {
  return request({
    url: '/md/look',
    method: 'post',
    data: data
  })
}

// 修改产品外观
export function updateLook(data) {
  return request({
    url: '/md/look',
    method: 'put',
    data: data
  })
}

// 删除产品外观
export function delLook(productLookId) {
  return request({
    url: '/md/look/' + productLookId,
    method: 'delete'
  })
}
