import request from '@/utils/request'

// 查询客户系人列表
export function listContact(query) {
  return request({
    url: '/md/clientContact/list',
    method: 'get',
    params: query
  })
}

// 查询客户系人详细
export function getContact(id) {
  return request({
    url: '/md/clientContact/' + id,
    method: 'get'
  })
}

// 新增客户系人
export function addContact(data) {
  return request({
    url: '/md/clientContact',
    method: 'post',
    data: data
  })
}

// 修改客户系人
export function updateContact(data) {
  return request({
    url: '/md/clientContact',
    method: 'put',
    data: data
  })
}

// 删除客户系人
export function delContact(id) {
  return request({
    url: '/md/clientContact/' + id,
    method: 'delete'
  })
}
