import request from '@/utils/request'

// 查询品牌报价列表
export function listBrandQuotation(query) {
  return request({
    url: '/dv/brandQuotation/list',
    method: 'get',
    params: query
  })
}

// 查询品牌报价详细
export function getBrandQuotation(brandQuantityId) {
  return request({
    url: '/dv/brandQuotation/' + brandQuantityId,
    method: 'get'
  })
}

// 新增品牌报价
export function addBrandQuotation(data) {
  return request({
    url: '/dv/brandQuotation',
    method: 'post',
    data: data
  })
}

// 修改品牌报价
export function updateBrandQuotation(data) {
  return request({
    url: '/dv/brandQuotation',
    method: 'put',
    data: data
  })
}

// 删除品牌报价
export function delBrandQuotation(brandQuantityId) {
  return request({
    url: '/dv/brandQuotation/' + brandQuantityId,
    method: 'delete'
  })
}
