import request from '@/utils/request'

// 查询刀模版物料申请单列表
export function listTmToolRequestItem(query) {
  return request({
    url: '/tm/tmToolRequestItem/list',
    method: 'get',
    params: query
  })
}

// 查询刀模版物料申请单详细
export function getTmToolRequestItem(toolRequestItemId) {
  return request({
    url: '/tm/tmToolRequestItem/' + toolRequestItemId,
    method: 'get'
  })
}

// 新增刀模版物料申请单
export function addTmToolRequestItem(data) {
  return request({
    url: '/tm/tmToolRequestItem',
    method: 'post',
    data: data
  })
}

// 修改刀模版物料申请单
export function updateTmToolRequestItem(data) {
  return request({
    url: '/tm/tmToolRequestItem',
    method: 'put',
    data: data
  })
}

// 删除刀模版物料申请单
export function delTmToolRequestItem(toolRequestItemId) {
  return request({
    url: '/tm/tmToolRequestItem/' + toolRequestItemId,
    method: 'delete'
  })
}
