import request from '@/utils/request'

// 查询刀模版上下机列表
export function listTmToolMachines(query) {
  return request({
    url: '/tm/tmToolMachines/list',
    method: 'get',
    params: query
  })
}

// 查询刀模版上下机详细
export function getTmToolMachines(toolMachinesId) {
  return request({
    url: '/tm/tmToolMachines/' + toolMachinesId,
    method: 'get'
  })
}

// 新增刀模版上下机
export function addTmToolMachines(data) {
  return request({
    url: '/tm/tmToolMachines',
    method: 'post',
    data: data
  })
}

// 修改刀模版上下机
export function updateTmToolMachines(data) {
  return request({
    url: '/tm/tmToolMachines',
    method: 'put',
    data: data
  })
}

// 删除刀模版上下机
export function delTmToolMachines(toolMachinesId) {
  return request({
    url: '/tm/tmToolMachines/' + toolMachinesId,
    method: 'delete'
  })
}
