import request from '@/utils/request'

// 查询生产工单尺码列表
export function listWorkOrderSoSizeItem(query) {
  return request({
    url: '/mes/pro/workOrderSoSizeItem/list',
    method: 'get',
    params: query
  })
}

// 查询生产工单尺码详细
export function getWorkOrderSoSizeItem(workorderSoSizeItemId) {
  return request({
    url: '/mes/pro/workOrderSoSizeItem/' + workorderSoSizeItemId,
    method: 'get'
  })
}

// 新增生产工单尺码
export function addWorkOrderSoSizeItem(data) {
  return request({
    url: '/mes/pro/workOrderSoSizeItem',
    method: 'post',
    data: data
  })
}

// 修改生产工单尺码
export function updateWorkOrderSoSizeItem(data) {
  return request({
    url: '/mes/pro/workOrderSoSizeItem',
    method: 'put',
    data: data
  })
}

// 删除生产工单尺码
export function delWorkOrderSoSizeItem(workorderSoSizeItemId) {
  return request({
    url: '/mes/pro/workOrderSoSizeItem/' + workorderSoSizeItemId,
    method: 'delete'
  })
}
